/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.ExecutionResultDetailPage;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;

public class ExecutionResultDetailPageProvider
implements DetailSection.IDetailPageProvider {
    private IDetailPage defaultDetailPage = new ExecutionResultDetailPage();
    private HashMap typeToPageMap = new HashMap();
    private List typesWithNoExtension = new ArrayList();

    private IDetailPage getExtensionPage(String resultType) {
        if (this.typesWithNoExtension.contains(resultType)) {
            return null;
        }
        IDetailPage page = (IDetailPage)this.typeToPageMap.get(resultType);
        if (page == null) {
            IDetailPageFactory provider = ExecutionHistoryExtensionsManager.getInstance().getResultDetailPageFactory(resultType);
            if (provider != null) {
                page = provider.createExecutionResultDetailPage(resultType);
            }
            if (page == null) {
                this.typesWithNoExtension.add(resultType);
            } else {
                this.typeToPageMap.put(resultType, page);
            }
        }
        return page;
    }

    public IDetailPage getDetailPage(Object element) {
        IDetailPage page = null;
        if (element instanceof TPFExecutionResult) {
            TPFExecutionResult result = (TPFExecutionResult)element;
            String type = result.getType();
            if (type != null && !"".equals(type)) {
                page = this.getExtensionPage(type);
            }
            if (page == null) {
                page = this.defaultDetailPage;
            }
        }
        return page;
    }

    public void dispose() {
        this.defaultDetailPage.dispose();
        for (IDetailPage page : this.typeToPageMap.values()) {
            page.dispose();
        }
    }
}

