/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenDownAction;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenUpAction;
import org.eclipse.hyades.test.ui.action.model.RemoveFeatureChildrenAction;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EObjectTableContentProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.action.AddConfigPropertyAction;
import org.eclipse.hyades.test.ui.internal.dialog.ComparablePropertyInputDialog;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;

public class PropertyGroupForm
extends EditorForm
implements IPropertyGroupForm {
    private String name;
    private String description;
    private CFGPropertyGroup propertyGroup;
    private EditorSection mainSection;
    private String editorType = "";
    public static final String CONTROL_TYPE_CUSTOM = "custom";
    public static final String CONTROL_TYPE_TABLE = "table";
    public static final String CONTROL_TYPE_TREE = "tree";
    public static final String CONTROL_TYPE_FIELDS = "fields";
    private String controlType = "table";
    private AddConfigPropertyAction addAction;
    private RemoveFeatureChildrenAction removeAction;

    public void init(CFGPropertyGroup propertyGroup, BaseEditorExtension editorExtension, WidgetFactory widgetFactory) {
        super.init(editorExtension, widgetFactory);
        this.propertyGroup = propertyGroup;
        if (propertyGroup.eContainer() != null) {
            this.editorType = propertyGroup.eContainer().eClass().getInstanceClassName();
        }
    }

    public void setExtension(IConfigurationElement extension) {
        this.name = extension.getAttribute("name");
        this.description = extension.getAttribute("description");
        this.controlType = extension.getAttribute("controlType");
        this.editorType = extension.getAttribute("appliesTo");
        if (extension.getAttribute("addAction") != null) {
            try {
                this.addAction = (AddConfigPropertyAction)((Object)extension.createExecutableExtension("addAction"));
                this.addAction.setPropertyGroup(this.propertyGroup);
            }
            catch (CoreException coreException) {}
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public CFGPropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getAppliesTo() {
        return this.editorType;
    }

    public void dispose() {
        if (this.mainSection != null) {
            this.mainSection.dispose();
            this.mainSection = null;
        }
        super.dispose();
    }

    protected EObject getEditorObject() {
        return ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getEditorObject();
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        this.createColumn(parent);
        if (this.controlType.equals(CONTROL_TYPE_TREE)) {
            this.mainSection = this.createTreeSection(leftColumn);
        } else if (this.controlType.equals(CONTROL_TYPE_TABLE)) {
            this.mainSection = this.createTableSection(leftColumn);
        } else {
            this.controlType.equals(CONTROL_TYPE_FIELDS);
        }
        if (this.mainSection != null) {
            this.registerSection(this.mainSection);
            this.mainSection.setHeaderText(this.getName());
            this.mainSection.setCollapsable(true);
            Control control = this.mainSection.createControl(leftColumn, this.getWidgetFactory());
            control.setLayoutData((Object)new GridData(1810));
        }
    }

    protected EditorSection createTreeSection(Composite parent) {
        IAction[] buttonActions = this.createButtonActions();
        ExtensibleEObjectTreeSection treeSection = new ExtensibleEObjectTreeSection(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), buttonActions);
        int i = 0;
        while (i < buttonActions.length) {
            IAction action = buttonActions[i];
            if (action != null && action instanceof ChildrenSelectionAction) {
                ((ChildrenSelectionAction)action).setStructuredViewer((StructuredViewer)treeSection.getTreeViewer());
            }
            ++i;
        }
        return treeSection;
    }

    protected EditorSection createTableSection(Composite parent) {
        IAction[] buttonActions = this.createButtonActions();
        PropertyGroupTableSection tableSection = new PropertyGroupTableSection(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), 3, buttonActions);
        tableSection.setContentProvider((IContentProvider)new EObjectTableContentProvider(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties()));
        tableSection.setLabelProvider(new PropertyGroupTableLabelProvider());
        int i = 0;
        while (i < buttonActions.length) {
            IAction action = buttonActions[i];
            if (action != null && action instanceof ChildrenSelectionAction) {
                ((ChildrenSelectionAction)action).setStructuredViewer((StructuredViewer)tableSection.getTableViewer());
            }
            ++i;
        }
        return tableSection;
    }

    protected IAction[] createButtonActions() {
        IAction[] buttonActions;
        if (this.addAction == null) {
            buttonActions = new IAction[3];
            this.removeAction = new RemoveFeatureChildrenAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), false);
            buttonActions[0] = this.removeAction;
            buttonActions[1] = new MoveFeatureChildrenUpAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
            buttonActions[2] = new MoveFeatureChildrenDownAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
        } else {
            buttonActions = new IAction[4];
            buttonActions[0] = this.addAction;
            this.removeAction = new RemoveFeatureChildrenAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), false);
            buttonActions[1] = this.removeAction;
            buttonActions[2] = new MoveFeatureChildrenUpAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
            buttonActions[3] = new MoveFeatureChildrenDownAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
        }
        return buttonActions;
    }

    public void load() {
        if (this.controlType.equals(CONTROL_TYPE_TREE)) {
            EObjectTreeSection section = (EObjectTreeSection)this.mainSection;
            section.setInput(this.propertyGroup);
        } else if (this.controlType.equals(CONTROL_TYPE_TABLE)) {
            ExtensibleEObjectTableSection section = (ExtensibleEObjectTableSection)this.mainSection;
            section.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)section);
            section.setInput(this.propertyGroup);
            section.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)section);
        } else {
            this.controlType.equals(CONTROL_TYPE_FIELDS);
        }
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection((Object)this.getEditorObject());
    }

    public void selectReveal(ISelection selection) {
        this.mainSection.selectReveal(selection);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (this.removeAction != null) {
                this.removeAction.run();
            }
            return true;
        }
        return false;
    }

    public class PropertyGroupTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CFGComparableProperty) {
                CFGComparableProperty property = (CFGComparableProperty)element;
                switch (columnIndex) {
                    case 0: {
                        if (property.getType() != null) {
                            return property.getType().getDisplayName();
                        }
                        return property.getName();
                    }
                    case 1: {
                        if (property.getOperator() == null) {
                            property.setOperator("=");
                        }
                        return property.getOperator();
                    }
                    case 2: {
                        return property.getValue();
                    }
                }
            }
            return null;
        }
    }

    protected class PropertyGroupTableSection
    extends ExtensibleEObjectTableSection {
        public PropertyGroupTableSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, int numOfColumns, IAction[] theButtonActions) {
            super(editorForm, eStructuralFeature, numOfColumns, theButtonActions);
        }

        protected void handleDoubleClick(IStructuredSelection structuredSelection) {
            if (structuredSelection.getFirstElement() instanceof CFGComparableProperty) {
                ComparablePropertyInputDialog dialog = new ComparablePropertyInputDialog(Display.getCurrent().getActiveShell(), UiPluginResourceBundle.DLG_EDIT_PROPERTY);
                dialog.setProperty((CFGComparableProperty)structuredSelection.getFirstElement());
                dialog.open();
            }
        }
    }
}

