/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class HyperlinkHandler
extends HyperlinkSettings
implements MouseListener,
MouseTrackListener,
SelectionListener,
PaintListener {
    private Hashtable hyperlinkListeners = new Hashtable();
    private Control lastActivated;
    private Control lastEntered;

    public Control getLastLink() {
        return this.lastActivated;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            return;
        }
        this.lastActivated = (Control)e.widget;
    }

    public void mouseEnter(MouseEvent e) {
        Control control = (Control)e.widget;
        this.linkEntered(control);
    }

    public void mouseExit(MouseEvent e) {
        Control control = (Control)e.widget;
        this.linkExited(control);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        Control linkControl = (Control)e.widget;
        Point size = linkControl.getSize();
        if (e.x < 0) {
            return;
        }
        if (e.y < 0) {
            return;
        }
        if (e.x >= size.x) {
            return;
        }
        if (e.y >= size.y) {
            return;
        }
        this.linkActivated(linkControl);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Control link = (Control)e.widget;
        this.linkActivated(link);
    }

    public void widgetSelected(SelectionEvent e) {
        Control link = (Control)e.widget;
        SelectableFormLabel l = (SelectableFormLabel)link;
        if (l.getSelection()) {
            this.linkEntered(link);
        } else {
            this.linkExited(link);
        }
    }

    private void linkActivated(Control link) {
        IHyperlinkListener action = (IHyperlinkListener)this.hyperlinkListeners.get(link);
        if (action != null) {
            link.setCursor(this.getBusyCursor());
            action.linkActivated(link);
            if (!link.isDisposed()) {
                link.setCursor(this.isHyperlinkCursorUsed() ? this.getHyperlinkCursor() : null);
            }
        }
    }

    private void linkEntered(Control link) {
        IHyperlinkListener action;
        if (this.lastEntered != null && this.lastEntered instanceof SelectableFormLabel) {
            SelectableFormLabel fl = (SelectableFormLabel)this.lastEntered;
            this.linkExited((Control)fl);
        }
        if (this.isHyperlinkCursorUsed()) {
            link.setCursor(this.getHyperlinkCursor());
        }
        if (this.activeBackground != null) {
            link.setBackground(this.activeBackground);
        }
        if (this.activeForeground != null) {
            link.setForeground(this.activeForeground);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(link, true);
        }
        if ((action = (IHyperlinkListener)this.hyperlinkListeners.get(link)) != null) {
            action.linkEntered(link);
        }
        this.lastEntered = link;
    }

    private void linkExited(Control link) {
        IHyperlinkListener action;
        if (this.isHyperlinkCursorUsed()) {
            link.setCursor(null);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(link, false);
        }
        if (this.background != null) {
            link.setBackground(this.background);
        }
        if (this.foreground != null) {
            link.setForeground(this.foreground);
        }
        if ((action = (IHyperlinkListener)this.hyperlinkListeners.get(link)) != null) {
            action.linkExited(link);
        }
        if (this.lastEntered == link) {
            this.lastEntered = null;
        }
    }

    public void paintControl(PaintEvent e) {
        Control label = (Control)e.widget;
        if (this.hyperlinkUnderlineMode == 3) {
            HyperlinkHandler.underline(label, true);
        }
    }

    public void registerHyperlink(Control control, IHyperlinkListener listener) {
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        control.addMouseListener((MouseListener)this);
        control.addMouseTrackListener((MouseTrackListener)this);
        if (this.hyperlinkUnderlineMode == 3 && control instanceof Label) {
            control.addPaintListener((PaintListener)this);
        }
        if (control instanceof SelectableFormLabel) {
            SelectableFormLabel sl = (SelectableFormLabel)control;
            sl.addSelectionListener(this);
            if (this.hyperlinkUnderlineMode == 3) {
                sl.setUnderlined(true);
            }
        }
        this.hyperlinkListeners.put(control, listener);
        this.removeDisposedLinks();
    }

    private void removeDisposedLinks() {
        Enumeration keys = this.hyperlinkListeners.keys();
        while (keys.hasMoreElements()) {
            Control control = (Control)keys.nextElement();
            if (!control.isDisposed()) continue;
            this.hyperlinkListeners.remove(control);
        }
    }

    public void reset() {
        this.hyperlinkListeners.clear();
    }

    public static void underline(Control control, boolean inside) {
        if (control instanceof SelectableFormLabel) {
            SelectableFormLabel l = (SelectableFormLabel)control;
            l.setUnderlined(inside);
            l.redraw();
            return;
        }
        if (!(control instanceof Label)) {
            return;
        }
        Composite parent = control.getParent();
        Rectangle bounds = control.getBounds();
        GC gc = new GC((Drawable)parent);
        Color color = inside ? control.getForeground() : control.getBackground();
        gc.setForeground(color);
        int y = bounds.y + bounds.height;
        gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        gc.dispose();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.removeDisposedLinks();
        Enumeration links = this.hyperlinkListeners.keys();
        while (links.hasMoreElements()) {
            Control control = (Control)links.nextElement();
            control.setForeground(color);
        }
    }
}

