/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class HyperlinkSettings {
    public static final int UNDERLINE_NEVER = 1;
    public static final int UNDERLINE_ROLLOVER = 2;
    public static final int UNDERLINE_ALWAYS = 3;
    protected boolean hyperlinkCursorUsed = true;
    protected int hyperlinkUnderlineMode = 3;
    protected Color background;
    protected Color foreground;
    protected Color activeBackground;
    protected Color activeForeground;
    protected static Cursors cursors = new Cursors();

    public HyperlinkSettings() {
        cursors.allocate();
    }

    public void dispose() {
        if (cursors != null) {
            cursors.dispose();
        }
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public Color getActiveForeground() {
        return this.activeForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Cursor getBusyCursor() {
        return HyperlinkSettings.cursors.busyCursor;
    }

    public Cursor getTextCursor() {
        return HyperlinkSettings.cursors.textCursor;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Cursor getHyperlinkCursor() {
        return HyperlinkSettings.cursors.hyperlinkCursor;
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkUnderlineMode;
    }

    public boolean isHyperlinkCursorUsed() {
        return this.hyperlinkCursorUsed;
    }

    public void setActiveBackground(Color newActiveBackground) {
        this.activeBackground = newActiveBackground;
    }

    public void setActiveForeground(Color newActiveForeground) {
        this.activeForeground = newActiveForeground;
    }

    public void setBackground(Color newBackground) {
        this.background = newBackground;
    }

    public void setForeground(Color newForeground) {
        this.foreground = newForeground;
    }

    public void setHyperlinkCursorUsed(boolean newHyperlinkCursorUsed) {
        this.hyperlinkCursorUsed = newHyperlinkCursorUsed;
    }

    public void setHyperlinkUnderlineMode(int newHyperlinkUnderlineMode) {
        this.hyperlinkUnderlineMode = newHyperlinkUnderlineMode;
    }

    static class Cursors {
        Cursor hyperlinkCursor;
        Cursor busyCursor;
        Cursor textCursor;
        int counter = 0;

        Cursors() {
        }

        public void allocate() {
            if (this.counter == 0) {
                this.hyperlinkCursor = new Cursor((Device)Display.getCurrent(), 21);
                this.busyCursor = new Cursor((Device)Display.getCurrent(), 1);
                this.textCursor = new Cursor((Device)Display.getCurrent(), 19);
            }
            ++this.counter;
        }

        public void dispose() {
            --this.counter;
            if (this.counter == 0) {
                this.hyperlinkCursor.dispose();
                this.busyCursor.dispose();
                this.textCursor.dispose();
                this.hyperlinkCursor = null;
                this.busyCursor = null;
                this.textCursor = null;
            }
        }
    }
}

