/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.graphics.Image;

public class Partition {
    private int offset;
    private int size;
    private EList children = null;
    private String label = null;

    public Partition(int offset, int size, EList children) {
        this.offset = offset;
        this.size = size;
        this.children = children;
        this.label = this.getLabel();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public List getChildren() {
        return this.children.subList(this.offset, this.offset + this.size);
    }

    public Object getChild(int index) {
        return this.children.get(this.offset + index);
    }

    public String getLabel() {
        if (this.label == null) {
            if (this.offset > -1 && this.size > -1) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("[");
                buffer.append(this.offset);
                buffer.append("...");
                buffer.append(this.offset + this.size - 1);
                buffer.append("]");
                this.label = buffer.toString();
            } else {
                this.label = UiPluginResourceBundle.PARTITION_LOADING_LABEL;
            }
        }
        return this.label;
    }

    public Image getImage() {
        if (this.offset > -1 && this.size > -1) {
            return TestUIImages.INSTANCE.getImage("partition_obj.gif");
        }
        return null;
    }
}

