/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SharedPartWithButtons;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerPart
extends SharedPartWithButtons {
    private StructuredViewer viewer;
    private Point minSize = null;
    private KeyListener deleteListener;

    public StructuredViewerPart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public StructuredViewerPart(String[] buttonLabels, String[] toolTips) {
        super(buttonLabels, toolTips);
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    protected void createMainControl(Composite parent, int style, int span, FormWidgetFactory factory) {
        this.createMainControl(parent, style, span, (Object)factory);
        Control control = this.viewer.getControl();
        if (factory != null) {
            factory.hookDeleteListener(control);
        }
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        control.setLayoutData((Object)gd);
        this.applyMinimumSize();
    }

    protected void createMainControl(Composite parent, int style, int span, FormToolkit factory) {
        this.createMainControl(parent, style, span, (Object)factory);
        Control control = this.viewer.getControl();
        if (this.deleteListener == null) {
            this.deleteListener = new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\u007f' && event.stateMask == 0) {
                        if (!(event.widget instanceof Control)) {
                            return;
                        }
                        Control control = (Control)event.widget;
                        Composite parent = control.getParent();
                        while (parent != null) {
                            if (parent.getData() instanceof FormSection) {
                                FormSection section = (FormSection)((Object)parent.getData());
                                section.doGlobalAction(ActionFactory.DELETE.getId());
                                break;
                            }
                            parent = parent.getParent();
                        }
                    }
                }
            };
        }
        control.addKeyListener(this.deleteListener);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = span;
        control.setLayoutData((Object)gd);
        this.applyMinimumSize();
    }

    private void createMainControl(Composite parent, int style, int span, Object factory) {
        this.viewer = factory instanceof FormToolkit ? this.createStructuredViewer(parent, style, (FormToolkit)factory) : this.createStructuredViewer(parent, style, (FormWidgetFactory)factory);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                StructuredViewerPart.this.selectionChanged((IStructuredSelection)e.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                StructuredViewerPart.this.handleDoubleClick((IStructuredSelection)e.getSelection());
            }
        });
    }

    public void setMinimumSize(int width, int height) {
        this.minSize = new Point(width, height);
        if (this.viewer != null) {
            this.applyMinimumSize();
        }
    }

    private void applyMinimumSize() {
        if (this.minSize != null) {
            GridData gd = (GridData)this.viewer.getControl().getLayoutData();
            gd.widthHint = this.minSize.x;
            gd.heightHint = this.minSize.y;
        }
    }

    protected void updateEnabledState() {
        this.getControl().setEnabled(this.isEnabled());
        super.updateEnabledState();
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, int var2, FormWidgetFactory var3);

    protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit factory) {
        return null;
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }
}

