/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableControl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ToggleControl
extends SelectableControl {
    protected boolean selection;
    private Color decorationColor;
    private Color activeColor;
    protected Cursor activeCursor;
    protected boolean hover = false;
    private static final int marginWidth = 2;
    private static final int marginHeight = 2;
    private static final int WIDTH = 9;
    private static final int HEIGHT = 9;
    private static final int[] offPoints;
    private static final int[] onPoints;

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 8;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 6;
        offPoints = nArray;
        onPoints = new int[]{2, -1, 2, 8, 6, 4};
    }

    public ToggleControl(Composite parent, int style) {
        super(parent, style);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToggleControl.this.selection = !ToggleControl.this.selection;
                ToggleControl.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                ToggleControl.this.hover = true;
                if (ToggleControl.this.activeCursor != null) {
                    ToggleControl.this.setCursor(ToggleControl.this.activeCursor);
                }
                ToggleControl.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                ToggleControl.this.hover = false;
                if (ToggleControl.this.activeCursor != null) {
                    ToggleControl.this.setCursor(null);
                }
                ToggleControl.this.redraw();
            }
        });
        this.initAccessible();
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = ToggleControl.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ToggleControl.this.toControl(new Point(e.x, e.y));
                if (ToggleControl.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ToggleControl.this.getBounds();
                Point pt = ToggleControl.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 35;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = ToggleControl.this.getSelection() ? 512 : 1024;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ToggleControl.this.getSelection() ? "1" : "0";
            }
        });
    }

    public void setDecorationColor(Color decorationColor) {
        this.decorationColor = decorationColor;
    }

    public Color getDecorationColor() {
        return this.decorationColor;
    }

    public void setActiveDecorationColor(Color activeColor) {
        this.activeColor = activeColor;
    }

    public void setActiveCursor(Cursor activeCursor) {
        this.activeCursor = activeCursor;
    }

    public Color getActiveDecorationColor() {
        return this.activeColor;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = wHint != -1 ? wHint : 13;
        int height = hHint != -1 ? hHint : 13;
        return new Point(width, height);
    }

    protected void paint(GC gc) {
        if (this.hover && this.activeColor != null) {
            gc.setBackground(this.activeColor);
        } else if (this.decorationColor != null) {
            gc.setBackground(this.decorationColor);
        } else {
            gc.setBackground(this.getForeground());
        }
        Point size = this.getSize();
        int x = (size.x - 9) / 2;
        int y = (size.y - 9) / 2;
        int[] data = this.selection ? this.translate(onPoints, x, y) : this.translate(offPoints, x, y);
        gc.fillPolygon(data);
        gc.setBackground(this.getBackground());
    }

    private int[] translate(int[] data, int x, int y) {
        int[] target = new int[data.length];
        int i = 0;
        while (i < data.length) {
            target[i] = data[i] + x;
            i += 2;
        }
        i = 1;
        while (i < data.length) {
            target[i] = data[i] + y;
            i += 2;
        }
        return target;
    }

    public boolean getSelection() {
        return this.selection;
    }

    public void setSelection(boolean selection) {
        this.selection = selection;
    }
}

