/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorEclipseForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.IDetailForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;

public class DetailPropertiesSection
implements IDetailPageContext {
    private PageBook pageBook;
    private IDetailFormProvider detailPageProvider;
    private Map controlByPage = new HashMap();
    private Composite defaultControl;
    private int maxHeight = 0;
    private IEditorExtension editor;
    private EditorEclipseForm form;
    private Object input;
    private FormToolkit toolkit;

    public DetailPropertiesSection(IEditorExtension editor, EditorEclipseForm form, FormToolkit toolkit) {
        this.editor = editor;
        this.form = form;
        this.toolkit = toolkit;
    }

    public void dispose() {
        this.input = null;
        this.controlByPage.clear();
        this.detailPageProvider.dispose();
    }

    public void setDetailPageProvider(IDetailFormProvider detailPageProvider) {
        this.detailPageProvider = detailPageProvider;
    }

    public Composite createDefaultControl(Composite parent) {
        Composite composite = this.toolkit.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.pageBook = new PageBook(composite, 0);
        this.pageBook.setLayoutData((Object)GridDataUtil.createFill());
        this.pageBook.setBackground(parent.getBackground());
        this.pageBook.setMenu(parent.getMenu());
        this.defaultControl = this.toolkit.createComposite((Composite)this.pageBook);
        this.defaultControl.setLayout((Layout)new GridLayout());
        this.defaultControl.setLayoutData((Object)GridDataUtil.createFill());
        Label label = this.toolkit.createLabel(this.defaultControl, UiPluginResourceBundle.NO_DETAILS);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        return composite;
    }

    public void setInput(Object object) {
        this.input = object;
        IDetailForm detailPage = this.getDetailPage(object);
        if (detailPage == null) {
            this.pageBook.showPage((Control)this.defaultControl);
        } else {
            detailPage.setInput(this.input);
            this.pageBook.showPage((Control)this.controlByPage.get(detailPage));
        }
    }

    public Object getInput() {
        return this.input;
    }

    public IStructuredSelection getStructuredSelection() {
        IDetailForm detailPage = this.getDetailPage(this.input);
        if (detailPage == null) {
            return StructuredSelection.EMPTY;
        }
        return detailPage.getStructuredSelection();
    }

    public void selectReveal(ISelection selection) {
        IDetailForm detailPage = this.getDetailPage(this.input);
        if (detailPage != null) {
            detailPage.selectReveal(selection);
        }
    }

    protected IDetailForm getDetailPage(Object input) {
        if (input != null) {
            if (input instanceof IStructuredSelection) {
                input = ((IStructuredSelection)input).getFirstElement();
            }
            if (input != null) {
                IDetailForm detailPage = this.detailPageProvider.getDetailPage(input);
                if (detailPage != null && !this.controlByPage.containsKey(detailPage)) {
                    Control control = detailPage.createControl((Composite)this.pageBook, this.toolkit, this);
                    control.setLayoutData((Object)GridDataUtil.createFill());
                    this.controlByPage.put(detailPage, control);
                    int height = control.computeSize((int)-1, (int)-1, (boolean)true).y;
                    if (height > this.maxHeight) {
                        ((GridData)this.pageBook.getLayoutData()).heightHint = this.maxHeight = height;
                        Control formControl = this.getEditorForm().getPartControl();
                        if (formControl != null && formControl instanceof Composite) {
                            ((Composite)formControl).layout(new Control[]{control});
                        }
                    }
                }
                return detailPage;
            }
        }
        return null;
    }

    public EditorEclipseForm getEditorForm() {
        return this.form;
    }

    public boolean isReadOnly() {
        return this.editor.getHyadesEditorPart().isReadOnly();
    }

    public void verifyKey(VerifyEvent event) {
        event.doit = !this.editor.getHyadesEditorPart().isReadOnly();
    }

    public static interface IDetailFormProvider
    extends IDisposable {
        public IDetailForm getDetailPage(Object var1);

        public void dispose();
    }
}

