/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class DetailSection
extends EditorSection
implements IDetailPageContext {
    private PageBook pageBook;
    private IDetailPageProvider detailPageProvider;
    private Map controlByPage;
    private Composite defaultControl;
    private FormWidgetFactory widgetFactory;
    private int maxHeight = 0;
    private Object input;

    public DetailSection(EditorForm editorForm) {
        super(editorForm);
        this.setCollapsable(true);
        this.controlByPage = new HashMap();
    }

    public void dispose() {
        this.input = null;
        this.controlByPage.clear();
        this.detailPageProvider.dispose();
        super.dispose();
    }

    public void setDetailPageProvider(IDetailPageProvider detailPageProvider) {
        this.detailPageProvider = detailPageProvider;
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.widgetFactory = factory;
        Composite composite = this.widgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.pageBook = new PageBook(composite, 0);
        this.pageBook.setLayoutData((Object)GridDataUtil.createFill());
        this.pageBook.setBackground(this.widgetFactory.getBackgroundColor());
        this.pageBook.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
        this.pageBook.setMenu(parent.getMenu());
        this.defaultControl = this.widgetFactory.createComposite((Composite)this.pageBook);
        this.defaultControl.setLayout((Layout)new GridLayout());
        this.defaultControl.setLayoutData((Object)GridDataUtil.createFill());
        Label label = this.widgetFactory.createLabel(this.defaultControl, UiPluginResourceBundle.NO_DETAILS);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        return composite;
    }

    public Composite getClient() {
        return this.pageBook;
    }

    public void setInput(Object object) {
        this.input = object;
        IDetailPage detailPage = this.getDetailPage(object);
        if (detailPage == null) {
            this.pageBook.showPage((Control)this.defaultControl);
        } else {
            detailPage.setInput(this.input);
            this.pageBook.showPage((Control)this.controlByPage.get(detailPage));
        }
    }

    public Object getInput() {
        return this.input;
    }

    public IStructuredSelection getStructuredSelection() {
        IDetailPage detailPage = this.getDetailPage(this.input);
        if (detailPage == null) {
            return StructuredSelection.EMPTY;
        }
        return detailPage.getStructuredSelection();
    }

    public void selectReveal(ISelection selection) {
        IDetailPage detailPage = this.getDetailPage(this.input);
        if (detailPage != null) {
            detailPage.selectReveal(selection);
        }
    }

    protected IDetailPage getDetailPage(Object input) {
        if (input != null) {
            if (input instanceof IStructuredSelection) {
                input = ((IStructuredSelection)input).getFirstElement();
            }
            if (input != null) {
                IDetailPage detailPage = this.detailPageProvider.getDetailPage(input);
                if (detailPage != null && !this.controlByPage.containsKey(detailPage)) {
                    Control control = detailPage.createControl((Composite)this.pageBook, this.widgetFactory, this);
                    control.setLayoutData((Object)GridDataUtil.createFill());
                    this.controlByPage.put(detailPage, control);
                    int height = control.computeSize((int)-1, (int)-1, (boolean)true).y;
                    if (height > this.maxHeight) {
                        ((GridData)this.pageBook.getLayoutData()).heightHint = this.maxHeight = height;
                        Control formControl = this.getEditorForm().getControl();
                        if (formControl != null && formControl instanceof Composite) {
                            ((Composite)formControl).layout(new Control[]{control});
                        }
                    }
                }
                return detailPage;
            }
        }
        return null;
    }

    public void addControlWithDetailPage(IDetailPage detailPage, Control control) {
        this.controlByPage.put(detailPage, control);
    }

    public static interface IDetailPageProvider
    extends IDisposable {
        public IDetailPage getDetailPage(Object var1);

        public void dispose();
    }
}

