/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.editor.form.util.EObjectContainerContentProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class EObjectTableContentProvider
extends EObjectContainerContentProvider {
    public EObjectTableContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
        super(editorForm, eStructuralFeature);
    }

    public TableViewer getTableViewer() {
        Viewer viewer = super.getViewer();
        if (viewer instanceof TableViewer) {
            return (TableViewer)viewer;
        }
        return null;
    }

    protected void updateViewer(Notification msg) {
        if (this.getViewer() == null) {
            return;
        }
        if (!(this.getViewer() instanceof StructuredViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (msg.getNotifier() != this.getContainer()) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: {
                    this.attributeChanged(msg);
                    return;
                }
            }
        }
        if (!(this.getViewer() instanceof TableViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (this.shouldUpdateViewer(msg)) {
            this.updateViewerWithNotification(msg);
        }
    }

    protected void updateViewerWithNotification(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                ((TableViewer)this.getViewer()).add(msg.getNewValue());
                this.getViewer().setSelection((ISelection)new StructuredSelection(msg.getNewValue()), true);
                break;
            }
            case 5: {
                Object[] addedObjects = ((Collection)msg.getNewValue()).toArray();
                ((TableViewer)this.getViewer()).add(addedObjects);
                this.getViewer().setSelection((ISelection)new StructuredSelection(addedObjects), true);
                break;
            }
            case 4: {
                ((TableViewer)this.getViewer()).remove(msg.getOldValue());
                Object value = ((EObject)msg.getNotifier()).eGet((EStructuralFeature)msg.getFeature());
                if (value instanceof List) {
                    List values = (List)value;
                    if (values.isEmpty()) {
                        this.getViewer().getControl().setFocus();
                        break;
                    }
                    int position = msg.getPosition();
                    position = position < values.size() ? position : values.size() - 1;
                    this.getViewer().setSelection((ISelection)new StructuredSelection(values.get(position)), true);
                    break;
                }
                this.getViewer().getControl().setFocus();
                break;
            }
            case 6: {
                ((TableViewer)this.getViewer()).remove(((Collection)msg.getOldValue()).toArray());
                this.getViewer().getControl().setFocus();
                break;
            }
            case 7: {
                this.getViewer().refresh();
            }
        }
    }
}

