/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Hashtable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TreePart;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeContentProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.GeneralStructureViewer;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.DrillDownAdapter;

public class EObjectTree
extends GeneralStructureViewer {
    private EStructuralFeature eStructuralFeature;
    protected DrillDownAdapter drillDownAdapter;
    protected CollapseAllAction collapseAllAction;
    protected IAction addAction;
    protected IAction insertAction;
    protected RemoveChildrenAction removeAction;
    protected MoveChildrenUpAction moveUpAction;
    protected MoveChildrenDownAction moveDownAction;
    private Separator workbenchAdditionsGroup;
    private TreeViewer treeViewer;
    private int treeStryle = 65538;
    private Hashtable customButtonHandler;
    private int[] buttonIndices;

    public EObjectTree(IEditorExtension editorPart, EStructuralFeature eStructuralFeature, IAction addAction) {
        super(editorPart);
        this.eStructuralFeature = eStructuralFeature;
        this.addAction = addAction;
        this.workbenchAdditionsGroup = new Separator("additions");
        this.treeStryle = 65538;
        String name = null;
        if (addAction != null) {
            name = addAction.getText();
        }
        this.adjustButtonLabels(name);
    }

    public void dispose() {
        this.eStructuralFeature = null;
        if (this.drillDownAdapter != null) {
            this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.drillDownAdapter);
            this.drillDownAdapter = null;
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.dispose();
            this.collapseAllAction = null;
        }
        if (this.removeAction != null) {
            this.removeAction.dispose();
            this.removeAction = null;
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.dispose();
            this.moveUpAction = null;
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.dispose();
            this.moveDownAction = null;
        }
        if (this.customButtonHandler != null) {
            this.customButtonHandler.clear();
            this.customButtonHandler = null;
        }
        this.workbenchAdditionsGroup.dispose();
        this.addAction = null;
        this.insertAction = null;
    }

    protected EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public void addButton(PrimitiveButtonHandler buttonHandler, String buttonLabel, String buttonToolTip, int index) {
        boolean isButtonHandlerNotNull;
        this.viewerPart.addButton(buttonLabel, buttonToolTip, index);
        boolean bl = isButtonHandlerNotNull = buttonHandler != null;
        if (this.customButtonHandler == null && isButtonHandlerNotNull) {
            this.customButtonHandler = new Hashtable();
        }
        if (isButtonHandlerNotNull) {
            this.customButtonHandler.put(new Integer(this.viewerPart.getButtonLength() - 1), buttonHandler);
        }
    }

    protected void adjustButtonLabels(String addLabel) {
        this.removeAction = new RemoveChildrenAction(false);
        this.moveUpAction = new MoveChildrenUpAction();
        this.moveDownAction = new MoveChildrenDownAction();
        this.setButtonLabels(new String[]{addLabel, this.removeAction.getText(), this.moveUpAction.getText(), this.moveDownAction.getText()});
    }

    protected void adjustButtonLabels(String addLabel, String insertLabel) {
        this.removeAction = new RemoveChildrenAction(false);
        this.moveUpAction = new MoveChildrenUpAction();
        this.moveDownAction = new MoveChildrenDownAction();
        this.setButtonLabels(new String[]{addLabel, insertLabel, this.removeAction.getText(), this.moveUpAction.getText(), this.moveDownAction.getText()}, new String[]{UiPluginResourceBundle.TOOLTIP_ADD, UiPluginResourceBundle.TOOLTIP_INSERT, UiPluginResourceBundle.TOOLTIP_REMOVE, UiPluginResourceBundle.TOOLTIP_UP, UiPluginResourceBundle.TOOLTIP_DOWN});
    }

    protected void setAddAction(IAction addAction) {
        this.addAction = addAction;
    }

    protected void setInsertAction(IAction insertAction) {
        this.insertAction = insertAction;
    }

    protected void adjustClient(Composite parent) {
        this.getTreeViewer().setContentProvider(this.createContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.getTreeViewer().setAutoExpandLevel(0);
        if (this.addAction != null) {
            this.viewerPart.setButtonEnabled(0, this.addAction.isEnabled());
        }
        if (this.insertAction != null) {
            this.viewerPart.setButtonEnabled(1, this.insertAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
        if (this.removeAction != null) {
            this.removeAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
    }

    protected IContentProvider createContentProvider() {
        return new EObjectTreeContentProvider(this.editorPart, this.getEStructuralFeature());
    }

    protected ILabelProvider createLabelProvider() {
        return new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class);
    }

    protected void createActions() {
        this.collapseAllAction = new CollapseAllAction(this.getTreeViewer()).useDefaultDecorators();
        this.drillDownAdapter = new DrillDownAdapter(this.getTreeViewer());
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.drillDownAdapter);
        if (this.removeAction != null) {
            this.removeAction.setEnabled(false);
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveDownAction.setEnabled(false);
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveUpAction.setEnabled(false);
        }
    }

    protected void buttonSelected(int index) {
        if (!this.editorPart.getHyadesEditorPart().isReadOnly()) {
            switch (index) {
                case 0: {
                    this.doAdd();
                    break;
                }
                case 1: {
                    this.doRemove();
                    break;
                }
                case 2: {
                    this.doMoveUp();
                    break;
                }
                case 3: {
                    this.doMoveDown();
                }
            }
        }
        this.updateActionsAndButtons((IStructuredSelection)this.viewerPart.getViewer().getSelection());
    }

    protected void doAdd() {
        if (this.addAction != null) {
            this.addAction.run();
        }
    }

    protected void doInsert() {
        if (this.insertAction != null) {
            this.insertAction.run();
        }
    }

    protected void doRemove() {
        if (this.removeAction != null) {
            this.removeAction.run();
        }
    }

    protected void doMoveUp() {
        if (this.moveUpAction != null) {
            this.moveUpAction.run();
        }
    }

    protected void doMoveDown() {
        if (this.moveDownAction != null) {
            this.moveDownAction.run();
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (this.removeAction != null) {
                this.removeAction.run();
            }
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        if (this.removeAction != null) {
            if (this.removeAction.isEnabled()) {
                this.removeAction.setEnabled(!this.editorPart.getHyadesEditorPart().isReadOnly());
            }
            menuManager.add((IAction)this.removeAction);
            menuManager.add((IContributionItem)new Separator());
        }
        boolean enableCollapse = false;
        TreeItem[] treeItems = this.getTreeViewer().getTree().getItems();
        int i = 0;
        int maxi = treeItems.length;
        while (i < maxi) {
            if (treeItems[i].getExpanded()) {
                enableCollapse = true;
                break;
            }
            ++i;
        }
        if (enableCollapse) {
            menuManager.add((IAction)this.collapseAllAction);
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IContributionItem)this.workbenchAdditionsGroup);
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
        if (this.addAction != null) {
            if (this.addAction instanceof SelectionListenerAction) {
                ((SelectionListenerAction)this.addAction).selectionChanged(structuredSelection);
            }
            this.viewerPart.setButtonEnabled(this.buttonIndices[0], this.addAction.isEnabled());
        }
        if (this.removeAction != null) {
            this.removeAction.selectionChanged(structuredSelection);
            this.viewerPart.setButtonEnabled(this.buttonIndices[1], this.removeAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.selectionChanged(structuredSelection);
            this.viewerPart.setButtonEnabled(this.buttonIndices[3], this.moveDownAction.isEnabled());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.selectionChanged(structuredSelection);
            this.viewerPart.setButtonEnabled(this.buttonIndices[2], this.moveUpAction.isEnabled());
        }
    }

    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        return new PartAdapter(buttonLabels);
    }

    protected StructuredViewerPart createViewerPart(String[] buttonLabels, String[] toolTips) {
        return new PartAdapter(buttonLabels, toolTips);
    }

    public Composite createControls(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        container.setLayout((Layout)layout);
        this.createViewerPartControl(container, this.getTreeStryle(), 2, toolkit);
        this.getTreeViewer().setAutoExpandLevel(-1);
        this.getTreeViewer().getControl().setFocus();
        this.adjustClient(parent);
        toolkit.paintBordersFor(container);
        return container;
    }

    public TreeViewer getTreeViewer() {
        if (this.treeViewer == null) {
            this.treeViewer = (TreeViewer)this.viewerPart.getViewer();
        }
        return this.treeViewer;
    }

    public int getTreeStryle() {
        return this.treeStryle;
    }

    public void setTreeStryle(int treeStryle) {
        this.treeStryle = treeStryle;
    }

    public StructuredViewerPart getViewerPart() {
        return this.viewerPart;
    }

    protected void selectionChanged(IStructuredSelection structuredSelection) {
        super.selectionChanged(structuredSelection);
        this.updateActionsAndButtons(structuredSelection);
    }

    public void setButtonIndices(int[] buttonIndices) {
        this.buttonIndices = buttonIndices;
    }

    public int[] getButtonIndices() {
        return this.buttonIndices;
    }

    protected class PartAdapter
    extends TreePart {
        public PartAdapter(String[] buttonLabels) {
            super(buttonLabels);
        }

        public PartAdapter(String[] buttonLabels, String[] toolTips) {
            super(buttonLabels, toolTips);
        }

        public void selectionChanged(IStructuredSelection selection) {
            EObjectTree.this.selectionChanged(selection);
        }

        public void handleDoubleClick(IStructuredSelection selection) {
            EObjectTree.this.handleDoubleClick(selection);
        }

        public void buttonSelected(Button button, int index) {
            if (index >= this.getStandardButtonLength()) {
                Object buttonHandlerObj = EObjectTree.this.customButtonHandler.get(new Integer(index));
                if (buttonHandlerObj != null) {
                    ((PrimitiveButtonHandler)buttonHandlerObj).buttonSelected(button);
                }
            } else {
                EObjectTree.this.buttonSelected(index);
            }
            if (EObjectTree.this.isHandlingDefaultButton()) {
                button.getShell().setDefaultButton(null);
            }
        }
    }

    public static interface PrimitiveButtonHandler {
        public void buttonSelected(Button var1);
    }
}

