/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.editor.form.util.IEventLabelProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.DefaultLabelProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Partition;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExecutionHistoryExtensionsManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;

public class EventLabelProvider
implements ILabelProvider {
    public IEventLabelProvider getProvider(String type) {
        return ExecutionHistoryExtensionsManager.getInstance().getEventLabelProvider(type);
    }

    public Image getImage(Object element) {
        Image icon = null;
        DefaultLabelProvider defaultProv = new DefaultLabelProvider();
        if (element instanceof Partition) {
            icon = ((Partition)element).getImage();
        } else if (element instanceof TPFExecutionResult) {
            TPFExecutionResult execResult = (TPFExecutionResult)element;
            IEventLabelProvider provider = this.getProvider(execResult.getType());
            icon = provider != null ? provider.getImage(element) : defaultProv.getImage(element);
        } else if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent execEvent = (TPFExecutionEvent)element;
            IEventLabelProvider provider = this.getProvider(execEvent.getEventType());
            icon = provider != null ? provider.getImage(element) : defaultProv.getImage(element);
        }
        return icon;
    }

    public String getText(Object element) {
        String label = "";
        DefaultLabelProvider defaultProv = new DefaultLabelProvider();
        if (element instanceof Partition) {
            label = ((Partition)element).getLabel();
        } else if (element instanceof TPFExecutionResult) {
            TPFExecutionResult execResult = (TPFExecutionResult)element;
            IEventLabelProvider provider = this.getProvider(execResult.getType());
            label = provider != null ? provider.getText(element) : defaultProv.getText(element);
        } else if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent execEvent = (TPFExecutionEvent)element;
            IEventLabelProvider provider = this.getProvider(execEvent.getEventType());
            label = provider != null ? provider.getText(element) : defaultProv.getText(element);
        }
        return TextProcessor.process((String)label);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

