/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;

public class ExtensionElementLink
implements IHyperlinkListener,
DisposeListener {
    private IExtensibleEditorExtension editorExtension;
    private SelectableFormLabel hyperlink;

    public ExtensionElementLink(IExtensibleEditorExtension editorExtension) {
        this.editorExtension = editorExtension;
    }

    public void create(FormWidgetFactory widgetFactory, Composite parent, IConfigurationElement extensionElement) {
        if (this.hyperlink != null) {
            return;
        }
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("propertyGroup_obj.gif");
        Label imageLabel = widgetFactory.createLabel(parent, "");
        imageLabel.setImage(imageDescriptor.createImage());
        String propertyGroupID = extensionElement.getAttribute("name");
        propertyGroupID = propertyGroupID == null ? "" : propertyGroupID;
        String tooltip = extensionElement.getAttribute("description");
        this.hyperlink = widgetFactory.createSelectableLabel(parent, propertyGroupID);
        widgetFactory.turnIntoHyperlink((Control)this.hyperlink, this);
        this.hyperlink.addDisposeListener(this);
        this.hyperlink.setToolTipText(tooltip);
        this.hyperlink.setData(extensionElement);
    }

    public void linkActivated(Control linkLabel) {
        Object linkData = linkLabel.getData();
        this.editorExtension.setSelection((IStructuredSelection)new StructuredSelection(linkData));
        if (linkData != null && linkData instanceof IConfigurationElement) {
            int index = this.editorExtension.addExtensionPage((IConfigurationElement)linkData);
            this.editorExtension.getHyadesEditorPart().setActivePage(index);
        }
    }

    public void linkEntered(Control linkLabel) {
        IActionBars actionBars = this.editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(((SelectableFormLabel)linkLabel).getText());
        }
    }

    public void linkExited(Control linkLabel) {
        IActionBars actionBars = this.editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.setMessage("");
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.hyperlink != null) {
            this.hyperlink.removeDisposeListener(this);
            this.hyperlink.setData(null);
            this.hyperlink = null;
        }
        this.editorExtension = null;
    }
}

