/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.models.common.common.CMNNodeInstance;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkAdapter;
import org.eclipse.hyades.test.ui.internal.editor.form.util.GeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class NodeGeneralInfoSection
extends GeneralInfoSection {
    private StyledText hostnameText;

    public NodeGeneralInfoSection(EditorForm editorForm, boolean hasResourceFileInfo) {
        super(editorForm, hasResourceFileInfo);
    }

    public void dispose() {
        super.dispose();
        this.hostnameText.dispose();
    }

    protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
        super.addSouthControls(parent, formWidgetFactory);
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        widgetFactory.createLabel(parent, UiPluginResourceBundle.LBL_HOST_NME);
        this.hostnameText = widgetFactory.createStyledText(parent, 65540);
        this.hostnameText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.hostnameText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.W_HOST_NME;
            }
        });
        widgetFactory.createHyperlinkLabel(parent, UiPluginResourceBundle.TEST_CONNECTION_NAME, new HyperlinkAdapter(){

            public void linkActivated(Control linkLabel) {
                TestUIUtilities.testConnection(NodeGeneralInfoSection.this.hostnameText.getText());
            }
        });
    }

    public void setEditable(boolean isEditable) {
        super.setEditable(isEditable);
        if (this.hostnameText != null) {
            this.hostnameText.setEditable(isEditable);
        }
    }

    public void setInput(Object object) {
        super.setInput(object);
        this.hostnameText.removeModifyListener((ModifyListener)this);
        String hostname = null;
        if (this.getNamedElement() instanceof CMNNodeInstance) {
            hostname = ((CMNNodeInstance)this.getNamedElement()).getHostname();
            hostname = hostname == null ? "" : hostname;
            this.hostnameText.setText(hostname);
        } else if (this.getNamedElement() instanceof CMNNodeType) {
            hostname = ((CMNNodeType)this.getNamedElement()).getHostname();
            hostname = hostname == null ? "" : hostname;
            this.hostnameText.setText(hostname);
        }
        this.hostnameText.addVerifyKeyListener((VerifyKeyListener)this);
        this.hostnameText.addModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent e) {
        super.modifyText(e);
        if (e.widget == this.hostnameText) {
            if (this.getNamedElement() instanceof CMNNodeInstance) {
                ((CMNNodeInstance)this.getNamedElement()).setHostname(this.hostnameText.getText());
            } else if (this.getNamedElement() instanceof CMNNodeType) {
                ((CMNNodeType)this.getNamedElement()).setHostname(this.hostnameText.getText());
            }
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }
}

