/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.UiPlugin;

public class EventUtil {
    public static String getTime(long timestamp) {
        return EventUtil.getTime(timestamp, TimeZone.getDefault());
    }

    public static String getTime(long timestamp, TimeZone timeZone) {
        if (timestamp > 0L) {
            try {
                DateFormat format = DateFormat.getDateTimeInstance((int)2, (int)1);
                format.setTimeZone(timeZone);
                return format.format(new Date(timestamp));
            }
            catch (RuntimeException e) {
                UiPlugin.logError(e);
            }
        }
        return "";
    }

    public static String getDuration(long startTimeStamp, long endTimeStamp) {
        if (startTimeStamp > 0L && endTimeStamp > 0L && endTimeStamp >= startTimeStamp) {
            return EventUtil.getTime(endTimeStamp - startTimeStamp, TimeZone.getTimeZone((String)"GMT"));
        }
        return "";
    }

    public static long getStartTimeStamp(TPFExecutionResult executionResult) {
        TPFExecutionHistory executionHistory;
        if (executionResult != null && (executionHistory = executionResult.getExecutionHistory()) != null) {
            EList executionEvents = executionHistory.getExecutionEvents();
            int counter = 0;
            while (counter < executionEvents.size()) {
                long timeStamp;
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)executionEvents.get(counter);
                if (executionEvent != null && (timeStamp = executionEvent.getTimestamp()) > 0L) {
                    return timeStamp;
                }
                ++counter;
            }
        }
        return 0L;
    }

    public static long getStopTimeStamp(TPFExecutionResult executionResult) {
        TPFExecutionHistory executionHistory;
        if (executionResult != null && (executionHistory = executionResult.getExecutionHistory()) != null) {
            EList executionEvents = executionHistory.getExecutionEvents();
            int counter = executionEvents.size() - 1;
            while (counter > -1) {
                long timeStamp;
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)executionEvents.get(counter);
                if (executionEvent != null && (timeStamp = executionEvent.getTimestamp()) > 0L) {
                    return timeStamp;
                }
                --counter;
            }
        }
        return 0L;
    }
}

