/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.views.properties.IPropertySource;

public class ResourceUtil {

    public static class ElementFactory
    implements IElementFactory {
        public static final String TAG_FILE = "FILE";

        public static void save(IMemento memento, Resource resource) {
            String filePath = EMFUtil.getFilePath((Resource)resource);
            memento.putString(TAG_FILE, filePath);
        }

        public IAdaptable createElement(IMemento memento) {
            String filePath = memento.getString(TAG_FILE);
            if (filePath == null) {
                return null;
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(filePath);
            if (resource == null || resource.getType() != 1) {
                return null;
            }
            EObject[] eObjects = EMFUtil.load(null, (IFile)((IFile)resource));
            if (eObjects.length > 0) {
                return new ResourceAdaptable(eObjects[0].eResource());
            }
            return null;
        }
    }

    public static class PersistableElement
    implements IPersistableElement,
    IDisposable {
        private Resource resource;

        public PersistableElement(Resource resource) {
            this.resource = resource;
        }

        public void dispose() {
            this.resource = null;
        }

        public String getFactoryId() {
            return ElementFactory.class.getName();
        }

        public void saveState(IMemento memento) {
            ElementFactory.save(memento, this.resource);
        }
    }

    public static class ResourceAdaptable
    implements IAdaptable,
    IDisposable {
        private Resource resource;

        public ResourceAdaptable(Resource resource) {
            this.resource = resource;
        }

        public void dispose() {
            this.resource = null;
        }

        public Resource getResource() {
            return this.resource;
        }

        public Object getAdapter(Class adapter) {
            if (Resource.class.isAssignableFrom(adapter)) {
                return this.getResource();
            }
            if (IPersistableElement.class == adapter) {
                return new PersistableElement(this.getResource());
            }
            IFile file = EMFUtil.getWorkspaceFile((Resource)this.getResource());
            if (IResource.class.isAssignableFrom(adapter)) {
                return file;
            }
            if (file != null && IPropertySource.class == adapter) {
                return file.getAdapter(IPropertySource.class);
            }
            return null;
        }
    }
}

