/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class RemoveChildrenAction
extends ChildrenSelectionAction {
    private boolean saveChanges;
    private boolean showErrorDialog;
    private boolean unloadNotSavedResource;

    public RemoveChildrenAction(boolean saveChanges) {
        super(UiPluginResourceBundle.BTN_REMOVE);
        this.saveChanges = saveChanges;
        if (saveChanges) {
            this.setText(UiPluginResourceBundle.LBL_DELETE);
        }
        this.setToolTipText(this.getText());
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getStructuredViewer() == null || this.getChildren().size() != 1) {
            return true;
        }
        return this.getStructuredViewer().getInput() != this.getChildren().get(0);
    }

    public void setUnloadNotSavedResource(boolean unloadNotSavedResource) {
        this.unloadNotSavedResource = unloadNotSavedResource;
    }

    public boolean isUnloadNotSavedResource() {
        return this.unloadNotSavedResource;
    }

    public boolean isSaveChanges() {
        return this.saveChanges;
    }

    public void setShowErrorDialog(boolean showErrorDialog) {
        this.showErrorDialog = showErrorDialog;
    }

    public boolean isShowErrorDialog() {
        return this.showErrorDialog;
    }

    public void run() {
        this.setActionPerformed(false);
        Set changedResources = this.breakFeatures(this.getStructuredSelection());
        if (changedResources.isEmpty()) {
            return;
        }
        List unsavedResources = this.saveResources(changedResources);
        changedResources.clear();
        if (unsavedResources.isEmpty()) {
            return;
        }
        this.handleUnsavedResources(unsavedResources);
        unsavedResources.clear();
    }

    protected Set breakFeatures(IStructuredSelection structuredSelection) {
        HashSet<Resource> changedResources = new HashSet<Resource>();
        for (EObject eObject : structuredSelection) {
            Resource[] resources = EMFUtil.remove((EObject)eObject);
            if (resources.length > 0) {
                this.setActionPerformed(true);
            }
            if (!this.isSaveChanges()) continue;
            changedResources.addAll(Arrays.asList(resources));
        }
        this.adjustStructuredViewer();
        this.getChildren().clear();
        return changedResources;
    }

    protected void adjustStructuredViewer() {
    }

    protected List saveResources(Set changedResources) {
        ArrayList<Resource> unsavedResources = new ArrayList<Resource>();
        for (Resource resource : changedResources) {
            try {
                EMFUtil.save((Resource)resource);
            }
            catch (Exception e) {
                UiPlugin.logError(e);
                unsavedResources.add(resource);
            }
        }
        return unsavedResources;
    }

    protected void handleUnsavedResources(List unsavedResources) {
        if (this.isShowErrorDialog()) {
            StringBuffer filePaths = new StringBuffer();
            for (Resource resource : unsavedResources) {
                String filePath = EMFUtil.getFilePath((Resource)resource);
                filePaths.append("\n").append(filePath);
            }
            String message = NLS.bind((String)UiPluginResourceBundle._ERROR_RESS_SAVE, (Object)filePaths.toString());
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)UiPluginResourceBundle.W_ERROR, (String)message);
        }
        if (this.isUnloadNotSavedResource()) {
            for (Resource resource : unsavedResources) {
                resource.unload();
            }
        }
    }
}

