/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.model.ResourceUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ExecutionContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigatorFrameSource;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionResourceChangeUpdater;
import org.eclipse.hyades.test.ui.internal.navigator.action.ExecutionNavigatorActionGroup;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExecutionNavigator
extends TreeNavigator {
    public static final String ID = "org.eclipse.hyades.test.ui.ExecutionNavigator";
    public static final int FILTER_SHOW_RUNNING = 1;
    public static final int FILTER_SHOW_FINISHED = 2;
    public static final int FILTER_SHOW_ALL = 3;
    private static Map execNavigatorByWorkbenchWindow;
    private ArrayList executionResults = new ArrayList();
    protected static final String SET_SHOW_FOLDERS = "SHOW_FOLDERS";
    protected static final String SET_SHOW_EOBJECT_CHILDREN = "SHOW_EOBJECT_CHILDREN";
    protected static final String SET_SORTER_CRITERIA = "SORTER_CRITERIA";
    protected static final int CP_FOLDER = 0;
    protected static final int CP_LOGICAL = 1;
    private List rootLogicalFolders;
    private boolean showingFolders = true;
    private boolean showingEObjectChildren = false;
    private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
    private ResourceSet resourceSet;
    private ExecutionContentProvider modelContentProvider;

    private static void addExecNavigator(ExecutionNavigator execNavigator) {
        if (execNavigatorByWorkbenchWindow == null) {
            execNavigatorByWorkbenchWindow = new HashMap();
        }
        execNavigatorByWorkbenchWindow.put(execNavigator.getSite().getWorkbenchWindow(), execNavigator);
    }

    private static void removeExecNavigator(ExecutionNavigator execNavigator) {
        if (execNavigatorByWorkbenchWindow != null) {
            execNavigatorByWorkbenchWindow.remove(execNavigator.getSite().getWorkbenchWindow());
            if (execNavigatorByWorkbenchWindow.isEmpty()) {
                execNavigatorByWorkbenchWindow = null;
            }
        }
    }

    public static ExecutionNavigator getExecNavigator(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow != null && execNavigatorByWorkbenchWindow != null) {
            return (ExecutionNavigator)((Object)execNavigatorByWorkbenchWindow.get(workbenchWindow));
        }
        return null;
    }

    public ExecutionNavigator() {
        super(ID);
        this.initializeResourceSet();
    }

    public void dispose() {
        if (this.executionResults != null) {
            this.executionResults.clear();
        }
        this.executionResults = null;
        if (this.rootLogicalFolders != null) {
            this.rootLogicalFolders.clear();
        }
        ExecutionNavigator.removeExecNavigator(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        this.resourceChangeUpdaterProvider.getResourceChangeUpdater().dispose();
        this.resourceChangeUpdaterProvider.dispose();
        this.resourceChangeUpdaterProvider = null;
        this.modelContentProvider.dispose();
        this.modelContentProvider = null;
        EMFUtil.removeAdapters((Iterator)this.resourceSet.getAllContents());
        this.resourceSet.getResources().clear();
        this.resourceSet.eAdapters().clear();
        this.resourceSet = null;
        super.dispose();
    }

    public String getStoreSection() {
        return "ExecutionNavigator";
    }

    protected void initializeResourceSet() {
        this.resourceSet = new ResourceSetImpl();
        this.modelContentProvider = new ExecutionContentProvider(this.getResourceSet());
        ExecutionContentProvider.ElementDescription elementDescription = new ExecutionContentProvider.ElementDescription("testsuite");
        elementDescription.getEClassifiers().add(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        this.modelContentProvider.addElementDescription(elementDescription);
    }

    protected void initSettings() {
        this.setShowingFolders(true);
        this.setShowingEObjectChildren(true);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        ExecutionNavigator.addExecNavigator(this);
    }

    public IFile getFile(Object object) {
        IFile file;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof Resource) {
            return EMFUtil.getWorkspaceFile((Resource)((Resource)object));
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eContainer() != null) {
                return null;
            }
            Resource resource = eObject.eResource();
            if (resource == null) {
                return null;
            }
            if (this.getResourceSet().getResource(resource.getURI(), false) == null) {
                return null;
            }
            return EMFUtil.getWorkspaceFile((Resource)resource);
        }
        if (object instanceof IAdaptable && (file = (IFile)((IAdaptable)object).getAdapter(IFile.class)) != null) {
            return file;
        }
        return null;
    }

    public void setMonitoringResourceChange(boolean enabled) {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().setActive(enabled);
        }
    }

    public boolean isMonitoringResourceChange() {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().isActive();
        }
        return false;
    }

    protected void loadSettings() {
        super.loadSettings();
        this.setShowingFolders(this.getSettings().getBoolean(SET_SHOW_FOLDERS));
        this.setShowingEObjectChildren(this.getSettings().getBoolean(SET_SHOW_EOBJECT_CHILDREN));
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        int criteria = 1;
        try {
            criteria = this.getSettings().getInt(SET_SORTER_CRITERIA);
        }
        catch (NumberFormatException numberFormatException) {}
        NavigatorViewerSorter viewerSorter = new NavigatorViewerSorter((INavigator)this, criteria){

            protected String getValue(Viewer viewer, Object e) {
                String value = super.getValue(viewer, e);
                if (e instanceof EObject) {
                    EObject eObject = (EObject)e;
                    if (eObject.eContainer() != null) {
                        return "";
                    }
                    if (this.getCriteria() == 2) {
                        if (eObject instanceof TPFTest) {
                            String type = ((TPFTest)eObject).getType();
                            value = type != null ? String.valueOf(type) + value : "zZz" + type;
                        }
                        value = String.valueOf(eObject.eClass().getName()) + value;
                    }
                }
                return value;
            }
        };
        treeViewer.setSorter((ViewerSorter)viewerSorter);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!ExecutionNavigator.this.isShowingEObjectChildren()) {
                    return !(parentElement instanceof EObject);
                }
                return true;
            }
        };
        treeViewer.addFilter(viewerFilter);
        this.resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider, 1);
        ExecutionResourceChangeUpdater resourceChangeUpdater = new ExecutionResourceChangeUpdater(this);
        this.resourceChangeUpdaterProvider.setResourceChangeUpdater((IResourceChangeUpdater)resourceChangeUpdater);
        treeViewer.setContentProvider((IContentProvider)this.modelContentProvider);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class), decorator){

            public Image getImage(Object element) {
                if (element instanceof INavigatorItem) {
                    return ((INavigatorItem)element).getImage();
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof INavigatorItem) {
                    return ((INavigatorItem)element).getText();
                }
                return super.getText(element);
            }
        });
    }

    protected boolean editorActivated(IEditorPart editor) {
        if (this.getViewer() == null) {
            return false;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            Resource resource = EMFUtil.getResource((ResourceSet)this.getResourceSet(), (IFile)file);
            if (resource != null && !resource.getContents().isEmpty()) {
                Object currentSelection;
                IStructuredSelection structuredSelection = this.getStructuredSelection();
                if (structuredSelection.size() == 1 && (currentSelection = structuredSelection.getFirstElement()) instanceof EObject && ((EObject)currentSelection).eResource() == resource) {
                    return true;
                }
                this.selectReveal((ISelection)new StructuredSelection(resource.getContents().get(0)));
                return true;
            }
        }
        return false;
    }

    protected void linkToEditor(IStructuredSelection structuredSelection) {
        IWorkbenchPage page;
        IEditorPart editor;
        IFile file = this.getFile(structuredSelection.getFirstElement());
        if (file != null && (editor = (page = this.getSite().getPage()).findEditor((IEditorInput)new FileEditorInput(file))) != null) {
            page.bringToTop((IWorkbenchPart)editor);
            return;
        }
    }

    public AbstractUIPlugin getPlugin() {
        return UiPlugin.getInstance();
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void createActions() {
        this.setActionGroup(new ExecutionNavigatorActionGroup(this));
    }

    public boolean isShowingFolders() {
        return this.showingFolders;
    }

    public void setShowingFolders(boolean enabled) {
        this.showingFolders = enabled;
        this.getSettings().put(SET_SHOW_FOLDERS, this.showingFolders);
        if (this.getViewer() == null) {
            return;
        }
        this.getViewer().refresh();
    }

    public boolean isShowingEObjectChildren() {
        return this.showingEObjectChildren;
    }

    public void setShowingEObjectChildren(boolean enabled) {
        this.showingEObjectChildren = enabled;
        this.modelContentProvider.setShowEnabledChildren(enabled);
        this.getSettings().put(SET_SHOW_EOBJECT_CHILDREN, this.showingEObjectChildren);
        if (this.getViewer() == null) {
            return;
        }
        this.getViewer().refresh();
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.getViewer(), (ISelection)StructuredSelection.EMPTY));
    }

    protected String getStatusLineMessage(IStructuredSelection structuredSelection) {
        if (structuredSelection.size() == 1) {
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof IResource) {
                return ((IResource)selection).getFullPath().toString();
            }
            if (selection instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)selection;
                if (logicalFolder.getChildren().size() == 0) {
                    return logicalFolder.getName();
                }
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_LOG_FLD, (Object[])new String[]{logicalFolder.getName(), Integer.toString(logicalFolder.getChildren().size())});
            }
            if (selection instanceof CMNNamedElement) {
                CMNNamedElement namedElement = (CMNNamedElement)selection;
                String label = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)namedElement);
                String filePath = EMFUtil.getFilePath((EObject)namedElement);
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_FILE_ELEM, (Object[])new String[]{label, filePath});
            }
            if (selection instanceof Resource) {
                Resource resource = (Resource)selection;
                String label = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)resource);
                String filePath = EMFUtil.getFilePath((Resource)resource);
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_FILE_ELEM, (Object[])new String[]{label, filePath});
            }
        }
        return super.getStatusLineMessage(structuredSelection);
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getViewer() == this.getTreeViewer()) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (element instanceof EObject || element instanceof Resource) {
                return;
            }
            TreeViewer treeViewer = this.getTreeViewer();
            if (treeViewer.isExpandable(element)) {
                treeViewer.setExpandedState(element, !treeViewer.getExpandedState(element));
            }
        }
    }

    protected IStructuredSelection convertToViewer(ISelection selection) {
        IStructuredSelection structuredSelection = super.convertToViewer(selection);
        if (structuredSelection.isEmpty()) {
            return structuredSelection;
        }
        ArrayList<Object> elements = new ArrayList<Object>(structuredSelection.size());
        for (Object object : structuredSelection) {
            if (object instanceof IFile) {
                EObject[] eObjects = EMFUtil.getEObjects((ResourceSet)this.getResourceSet(), (IFile)((IFile)object));
                int j = 0;
                int maxj = eObjects.length;
                while (j < maxj) {
                    if (eObjects[j] instanceof CMNNamedElement) {
                        elements.add(eObjects[j]);
                    }
                    ++j;
                }
                continue;
            }
            if (object instanceof EObject) {
                EObject eObject = EMFUtil.getEObject((ResourceSet)this.resourceSet, (EObject)((EObject)object), (boolean)false);
                if (eObject == null || eObject.eContainer() != null && !this.isShowingEObjectChildren()) continue;
                elements.add(eObject);
                continue;
            }
            elements.add(object);
        }
        return new StructuredSelection(elements);
    }

    public void handleChange(int type) {
        if (NavigatorViewerSorter.SORTER_TYPE == type) {
            this.getSettings().put(SET_SORTER_CRITERIA, ((NavigatorViewerSorter)this.getViewer().getSorter()).getCriteria());
            NavigatorActionGroup actionGroup = this.getActionGroup();
            if (actionGroup != null) {
                actionGroup.updateActionBars();
            }
        }
        super.handleChange(type);
    }

    public Object getInitialViewerInput() {
        return super.getInitialViewerInput();
    }

    protected TreeNavigatorFrameSource createFrameSource() {
        return new ExecutionNavigatorFrameSource(this);
    }

    public LogicalFolder getRootLogicalFolder(String name) {
        if (this.rootLogicalFolders != null && name != null) {
            for (LogicalFolder logicalFolder : this.rootLogicalFolders) {
                if (!name.equals(logicalFolder.getName())) continue;
                return logicalFolder;
            }
        }
        return null;
    }

    protected List loadElements(IMemento memento) {
        Object[] objects = super.loadElements(memento).toArray();
        ArrayList<Object> elements = new ArrayList<Object>(objects.length);
        int i = 0;
        int maxi = objects.length;
        while (i < maxi) {
            if (objects[i] instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)objects[i];
                Object parent = logicalFolder.getParent();
                if (parent == null) {
                    if ((logicalFolder = this.getRootLogicalFolder(logicalFolder.getName())) != null) {
                        elements.add(logicalFolder);
                    }
                } else if (parent instanceof EObject) {
                    EObject eObject = EMFUtil.getEObject((ResourceSet)this.getResourceSet(), (EObject)((EObject)parent), (boolean)true);
                    if (eObject != null) {
                        LogicalFolder newLogicalFolder = new LogicalFolder((Object)eObject, logicalFolder.getName());
                        newLogicalFolder.setData(logicalFolder.getData());
                        newLogicalFolder.setDescription(logicalFolder.getDescription());
                        elements.add(newLogicalFolder);
                    }
                } else {
                    elements.add(logicalFolder);
                }
            } else if (objects[i] instanceof EObject) {
                EObject eObject = EMFUtil.getEObject((ResourceSet)this.getResourceSet(), (EObject)((EObject)objects[i]), (boolean)true);
                if (eObject != null) {
                    elements.add(eObject);
                }
            } else if (objects[i] instanceof ResourceUtil.ResourceAdaptable) {
                Resource resource = ((ResourceUtil.ResourceAdaptable)objects[i]).getResource();
                if (resource != null && (resource = this.getResourceSet().getResource(resource.getURI(), true)) != null) {
                    elements.add(resource);
                }
            } else {
                elements.add(objects[i]);
            }
            ++i;
        }
        return elements;
    }

    protected String getHelpContextId() {
        return String.valueOf(UiPlugin.getID()) + ".enav0001";
    }

    public String getID() {
        return ID;
    }
}

