/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.IProxiesRequestListener;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.LogicalProjectProxiesRequest;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ProxiesRequest;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.graphics.Image;

public class LogicalTestNavigatorContentProvider
extends TestNavigatorContentProvider {
    private static FileProxyManager fileProxyManager = new FileProxyManager();
    private ProxiesRequests requests = new ProxiesRequests();

    public static IFileProxyManager getSharedFileProxyManager() {
        return fileProxyManager;
    }

    public LogicalTestNavigatorContentProvider(TestNavigator testNavigator) {
        super(testNavigator);
    }

    protected IFileProxyManager getFileProxyManager() {
        return fileProxyManager;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement == null) {
            return false;
        }
        if (parentElement instanceof IProject) {
            return true;
        }
        return super.hasChildren(parentElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            IProject project = (IProject)parentElement;
            if (project.isAccessible()) {
                IProxyNode proxy;
                Collection types = this.getTypes();
                Collection extensions = this.getExtensions();
                ArrayList<IProxyNode> ret = new ArrayList<IProxyNode>(types.size() + extensions.size());
                LogicalProjectProxiesRequest request = this.requests.getRequest(project, types, extensions);
                for (String type : types) {
                    proxy = request.getProxy("#" + type);
                    if (proxy == null) continue;
                    ret.add(proxy);
                }
                for (String ext : extensions) {
                    proxy = request.getProxy("~" + ext);
                    if (proxy == null) continue;
                    ret.add(proxy);
                }
                if (request.isPending()) {
                    ret.add(0, new PendingProxy(project));
                }
                return ret.toArray();
            }
            return new Object[0];
        }
        return super.getChildren(parentElement);
    }

    private Collection getTypes() {
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        String[] types = associationMapping.getTypes();
        ArrayList<String> typeProviders = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(types[i]);
            if (descriptor != null) {
                typeProviders.add(types[i]);
            }
            ++i;
        }
        return typeProviders;
    }

    private Collection getExtensions() {
        return TestNavigator.getTestAssetGroupProxyManager().getExtensions();
    }

    public TestNavigatorContentProvider.IGlobalProxyNodeListener getProxyNodeListener() {
        return this.requests;
    }

    public void dispose() {
        this.requests.dispose();
    }

    private static class PendingProxy
    implements IProxyNode {
        private Object parent;
        private static IProxyNode[] NO_CHILDREN = new IProxyNode[0];

        public PendingProxy(Object parent) {
            this.parent = parent;
        }

        public IProxyNode[] getChildren() {
            return NO_CHILDREN;
        }

        public Image getImage() {
            return null;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getText() {
            return TestNavigatorMessages.NODE_PENDING;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getIdentifier() {
            return "~";
        }

        public IResource getUnderlyingResource() {
            return null;
        }
    }

    class ProxiesRequests
    implements IProxiesRequestListener,
    TestNavigatorContentProvider.IGlobalProxyNodeListener,
    IDisposable {
        private Map projectToRequestMap = Collections.synchronizedMap(new HashMap());

        ProxiesRequests() {
        }

        public LogicalProjectProxiesRequest getRequest(IProject project, Collection types, Collection extensions) {
            LogicalProjectProxiesRequest req = (LogicalProjectProxiesRequest)this.projectToRequestMap.get(project);
            if (req == null) {
                ArrayList<String> requests = new ArrayList<String>(types.size() + extensions.size());
                Iterator it = types.iterator();
                while (it.hasNext()) {
                    requests.add("#" + (String)it.next());
                }
                it = extensions.iterator();
                while (it.hasNext()) {
                    requests.add("~" + (String)it.next());
                }
                req = new LogicalProjectProxiesRequest(requests, TestNavigator.getTypeProviderManager(), TestNavigator.getTestAssetGroupProxyManager(), project, LogicalTestNavigatorContentProvider.this.testNavigator);
                req.setPriority(LogicalTestNavigatorContentProvider.this.getJobPriority());
                LogicalTestNavigatorContentProvider.this.testNavigator.getJobPool().scheduleJob(req);
                if (!req.wait(LogicalTestNavigatorContentProvider.this.getResponseTime(), this, 2000)) {
                    this.projectToRequestMap.put(project, req);
                }
            }
            return req;
        }

        public void computationCompleted(ProxiesRequest request) {
            IProject project = ((LogicalProjectProxiesRequest)request).getProject();
            if (this.projectToRequestMap.containsKey(project)) {
                LogicalTestNavigatorContentProvider.this.testNavigator.refresh(project);
            }
        }

        public void proxiesComputed(ProxiesRequest request) {
            IProject project = ((LogicalProjectProxiesRequest)request).getProject();
            LogicalTestNavigatorContentProvider.this.testNavigator.refresh(project);
        }

        public void proxyComputed(ProxiesRequest request, Object key) {
        }

        public void nodeChanged(Object node) {
            LogicalProjectProxiesRequest req;
            if (node instanceof IProject && (req = (LogicalProjectProxiesRequest)this.projectToRequestMap.get(node)) != null && req.cancel(1000)) {
                this.projectToRequestMap.remove(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodesChanged() {
            Object[] copyKeySet = null;
            Map map = this.projectToRequestMap;
            synchronized (map) {
                copyKeySet = this.projectToRequestMap.keySet().toArray();
            }
            int i = 0;
            while (i < copyKeySet.length) {
                this.nodeChanged(copyKeySet[i]);
                ++i;
            }
        }

        public void computationCancelled(ProxiesRequest request) {
            IProject project = ((LogicalProjectProxiesRequest)request).getProject();
            this.projectToRequestMap.remove(project);
            LogicalTestNavigatorContentProvider.this.testNavigator.refresh(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Object[] values = null;
            Map map = this.projectToRequestMap;
            synchronized (map) {
                values = this.projectToRequestMap.values().toArray();
            }
            int i = 0;
            while (i < values.length) {
                ProxiesRequest request = (ProxiesRequest)((Object)values[i]);
                request.dispose();
                this.projectToRequestMap.values().remove((Object)request);
                ++i;
            }
        }
    }
}

