/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.FileProxiesRequest;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.IProxiesRequestListener;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ProxiesRequest;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.util.IDisposable;

public class ResourceTestNavigatorContentProvider
extends TestNavigatorContentProvider {
    private static FileProxyManager fileProxyManager = new FileProxyManager();
    private FileProxyRequests requests = new FileProxyRequests();

    public static FileProxyManager getSharedFileProxyManager() {
        return fileProxyManager;
    }

    public ResourceTestNavigatorContentProvider(TestNavigator testNavigator) {
        super(testNavigator);
    }

    protected IFileProxyManager getFileProxyManager() {
        return fileProxyManager;
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return super.getParent(element);
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement == null) {
            return false;
        }
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            if (!container.isAccessible()) {
                return false;
            }
            IResource[] resources = null;
            try {
                resources = container.members();
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return false;
            }
            if (resources.length == 0) {
                return false;
            }
            if (parentElement instanceof IProject) {
                return true;
            }
            int i = 0;
            while (i < resources.length) {
                String fileExtension;
                if (resources[i].getType() != 1 ? !TestNavigator.getFiltersManager().filter(resources[i]) : (fileExtension = resources[i].getFileExtension()) != null && TestNavigator.getFiltersManager().isVisibleResource(resources[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return super.hasChildren(parentElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            return this.getContainerChildren(parentElement);
        }
        return super.getChildren(parentElement);
    }

    private Object[] getContainerChildren(Object parentElement) {
        IResource[] resources = null;
        IContainer container = (IContainer)parentElement;
        if (container.isAccessible()) {
            try {
                resources = container.members();
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return new Object[0];
            }
            ArrayList<Object> children = new ArrayList<Object>(resources.length);
            FileProxiesRequest request = this.requests.getRequest(container, resources);
            int i = 0;
            int maxi = resources.length;
            while (i < maxi) {
                if (!TestNavigator.getFiltersManager().filter(resources[i])) {
                    if (resources[i].getType() != 1) {
                        children.add(resources[i]);
                    } else {
                        IFile file = (IFile)resources[i];
                        IProxyNode node = request.getProxy(file);
                        if (!TestNavigator.getFiltersManager().filter(node)) {
                            children.add(node);
                            fileProxyManager.cacheProxy(file, node);
                        }
                    }
                }
                ++i;
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public TestNavigatorContentProvider.IGlobalProxyNodeListener getProxyNodeListener() {
        return this.requests;
    }

    public void dispose() {
        this.requests.dispose();
    }

    private class FileProxyRequests
    implements IProxiesRequestListener,
    IDisposable,
    TestNavigatorContentProvider.IGlobalProxyNodeListener {
        private Map containerToRequestMap = Collections.synchronizedMap(new HashMap());

        private FileProxyRequests() {
        }

        public FileProxiesRequest getRequest(IContainer container, IResource[] members) {
            FileProxiesRequest request = (FileProxiesRequest)this.containerToRequestMap.get(container);
            if (request == null) {
                request = this.newRequest(container, members);
            }
            return request;
        }

        public FileProxiesRequest newRequest(IContainer container, IResource[] members) {
            ArrayList<IResource> filesToRequest = new ArrayList<IResource>(members.length);
            int i = 0;
            int maxi = members.length;
            while (i < maxi) {
                if (members[i].getType() == 1 && !TestNavigator.getFiltersManager().filter(members[i])) {
                    filesToRequest.add(members[i]);
                }
                ++i;
            }
            if (filesToRequest.isEmpty()) {
                return null;
            }
            FileProxiesRequest req = new FileProxiesRequest(filesToRequest, fileProxyManager, container, ResourceTestNavigatorContentProvider.this.testNavigator);
            req.setPriority(ResourceTestNavigatorContentProvider.this.getJobPriority());
            ResourceTestNavigatorContentProvider.this.testNavigator.getJobPool().scheduleJob(req);
            if (!req.wait(ResourceTestNavigatorContentProvider.this.getResponseTime(), this, 2000)) {
                this.containerToRequestMap.put(container, req);
            }
            return req;
        }

        public void proxyComputed(ProxiesRequest request, Object key) {
        }

        public void computationCompleted(ProxiesRequest request) {
            IContainer parent = ((FileProxiesRequest)request).getParent();
            if (this.containerToRequestMap.containsKey(parent)) {
                ResourceTestNavigatorContentProvider.this.testNavigator.refresh(parent);
            }
        }

        public void dispose() {
            Iterator it = this.containerToRequestMap.values().iterator();
            while (it.hasNext()) {
                FileProxiesRequest request = (FileProxiesRequest)it.next();
                request.dispose();
                it.remove();
            }
        }

        public void proxiesComputed(ProxiesRequest request) {
            ResourceTestNavigatorContentProvider.this.testNavigator.refresh(((FileProxiesRequest)request).getParent());
        }

        public void nodeChanged(Object node) {
            FileProxiesRequest req;
            if (node instanceof IContainer && (req = (FileProxiesRequest)this.containerToRequestMap.remove(node)) != null && req.cancel(1000)) {
                this.containerToRequestMap.remove(node);
            }
        }

        public void nodesChanged() {
            Iterator it = this.containerToRequestMap.keySet().iterator();
            while (it.hasNext()) {
                this.nodeChanged(it.next());
            }
        }

        public void computationCancelled(ProxiesRequest request) {
            IContainer parent = ((FileProxiesRequest)request).getParent();
            this.containerToRequestMap.remove(parent);
            ResourceTestNavigatorContentProvider.this.testNavigator.refresh(parent);
        }
    }
}

