/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class TestDecoratingLabelProvider
extends DecoratingLabelProvider
implements ILabelProviderListener {
    private final TestNavigator testNavigator;

    public TestDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator, TestNavigator testNavigator) {
        super(provider, decorator);
        this.testNavigator = testNavigator;
        if (decorator != null) {
            decorator.addListener((ILabelProviderListener)this);
        }
    }

    public void dispose() {
        ILabelDecorator decorator = this.getLabelDecorator();
        if (decorator != null) {
            decorator.removeListener((ILabelProviderListener)this);
        }
        super.dispose();
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        Object[] elements = event.getElements();
        ArrayList<IProxyNode> others = new ArrayList<IProxyNode>();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                IProxyNode converted;
                IFile file;
                Object elem = elements[i];
                if (elem instanceof IFile && (file = (IFile)elem).exists() && (converted = FileProxyNodeCache.getInstance().getCachedProxy(file)) != null && this.testNavigator.getCurrentFileProxyManager().getParent(converted) != null) {
                    others.add(converted);
                }
                ++i;
            }
            if (others.size() > 0) {
                event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
                this.fireLabelProviderChanged(event);
            }
        }
    }
}

