/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.editor.BaseEditorPart;
import org.eclipse.hyades.test.ui.internal.model.ResourceUtil;
import org.eclipse.hyades.test.ui.internal.navigator.LogicalTestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.ResourceTestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestDecoratingLabelProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorFilterExtensionsManager;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorFrameSource;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorLabelProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestResourceChangeUpdater;
import org.eclipse.hyades.test.ui.internal.navigator.action.TestNavigatorActionGroup;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleViewAction;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileFactoryManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestAssetGroupProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypeProviderManager;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.FixedSizeJobPool;
import org.eclipse.hyades.test.ui.navigator.AbstractProxy;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.ITestNavigator;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TestNavigator
extends TreeNavigator
implements ISelectionListener,
TestNavigatorContentProvider.IGlobalProxyNodeListener,
ITestNavigator {
    public static final String ID = "org.eclipse.hyades.test.ui.TestNavigator";
    public static final int VIEW_ID_RESOURCE = 0;
    public static final int VIEW_ID_LOGICAL = 1;
    public static final int BACKGROUND_JOB_POOL_SIZE = 3;
    private int currentViewIndex;
    private static Map testNavigatorByWorkbenchWindow;
    private static TestNavigatorFilterExtensionsManager filtersManager;
    private static FileFactoryManager fileFactoryManager;
    private static TypeProviderManager typeProviderManager;
    private static TestAssetGroupProxyManager testAssetGroupProxyManager;
    private static TypeProviderContext typeProviderContext;
    private ToggleViewAction[] viewActions = new ToggleViewAction[]{new ToggleViewAction(this, 0), new ToggleViewAction(this, 1)};
    private TestNavigatorContentProvider currentContentProvider;
    protected static final String SET_SHOW_FOLDERS = "SHOW_FOLDERS";
    protected static final String SET_SHOW_EOBJECT_CHILDREN = "SHOW_EOBJECT_CHILDREN";
    protected static final String SET_SORTER_CRITERIA = "SORTER_CRITERIA";
    protected static final String DIALOGSTORE_HTN_VIEW = "TestNavigator.lastview";
    protected static final int CP_FOLDER = 0;
    protected static final int CP_LOGICAL = 1;
    private List rootLogicalFolders;
    private boolean showingFolders = true;
    private boolean showingEObjectChildren = true;
    private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
    private FixedSizeJobPool jobPool;
    private ResourceTestNavigatorContentProvider resourceProv = null;
    private LogicalTestNavigatorContentProvider logicalProv = null;
    private TestDecoratingLabelProvider labelProv = null;

    public TestNavigator() {
        super(ID);
    }

    private static void addTestNavigator(TestNavigator testNavigator) {
        if (testNavigatorByWorkbenchWindow == null) {
            testNavigatorByWorkbenchWindow = new HashMap();
        }
        testNavigatorByWorkbenchWindow.put(testNavigator.getSite().getWorkbenchWindow(), testNavigator);
    }

    private static void removeTestNavigator(TestNavigator testNavigator) {
        if (testNavigatorByWorkbenchWindow != null) {
            testNavigatorByWorkbenchWindow.remove(testNavigator.getSite().getWorkbenchWindow());
            if (testNavigatorByWorkbenchWindow.isEmpty()) {
                testNavigatorByWorkbenchWindow = null;
            }
        }
    }

    public static TestNavigator getTestNavigator(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow != null && testNavigatorByWorkbenchWindow != null) {
            return (TestNavigator)testNavigatorByWorkbenchWindow.get(workbenchWindow);
        }
        return null;
    }

    public static TestNavigatorFilterExtensionsManager getFiltersManager() {
        if (filtersManager == null) {
            filtersManager = new TestNavigatorFilterExtensionsManager();
        }
        return filtersManager;
    }

    public static FileFactoryManager getFileFactoryManager() {
        if (fileFactoryManager == null) {
            fileFactoryManager = new FileFactoryManager();
        }
        return fileFactoryManager;
    }

    public static IFileProxyManager getFileProxyManager() {
        TestNavigator testNavigator;
        IWorkbenchWindow activeWorkbenchWindow;
        IFileProxyManager fileProxyManager = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (testNavigator = TestNavigator.getTestNavigator(activeWorkbenchWindow)) != null) {
            fileProxyManager = testNavigator.getCurrentFileProxyManager();
        }
        return fileProxyManager;
    }

    public IFileProxyManager getCurrentFileProxyManager() {
        return this.currentContentProvider.getFileProxyManager();
    }

    public static synchronized TypeProviderManager getTypeProviderManager() {
        if (typeProviderManager == null) {
            typeProviderManager = new TypeProviderManager(TestNavigator.getTypeProviderContext());
        }
        return typeProviderManager;
    }

    public static ITypeProviderContext getTypeProviderContext() {
        if (typeProviderContext == null) {
            typeProviderContext = new TypeProviderContext();
        }
        return typeProviderContext;
    }

    public static synchronized TestAssetGroupProxyManager getTestAssetGroupProxyManager() {
        if (testAssetGroupProxyManager == null) {
            testAssetGroupProxyManager = new TestAssetGroupProxyManager(TestNavigator.getTypeProviderContext());
        }
        return testAssetGroupProxyManager;
    }

    public void dispose() {
        if (this.jobPool != null) {
            this.jobPool.dispose();
        }
        Job.getJobManager().cancel((Object)this);
        if (this.rootLogicalFolders != null) {
            this.rootLogicalFolders.clear();
        }
        TestNavigator.removeTestNavigator(this);
        FileProxyNodeCache.getInstance().removeResourceListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        this.resourceChangeUpdaterProvider.getResourceChangeUpdater().dispose();
        this.resourceChangeUpdaterProvider.dispose();
        this.resourceChangeUpdaterProvider = null;
        if (testAssetGroupProxyManager != null) {
            testAssetGroupProxyManager.dispose();
            testAssetGroupProxyManager = null;
        }
        if (typeProviderManager != null) {
            typeProviderManager.dispose();
            typeProviderManager = null;
        }
        super.dispose();
    }

    public String getStoreSection() {
        return "TestNavigator";
    }

    protected void initSettings() {
        this.setShowingFolders(true);
        this.setShowingEObjectChildren(false);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        TestNavigator.addTestNavigator(this);
        ((IContextService)this.getSite().getService(IContextService.class)).activateContext("org.eclipse.hyades.test.ui.testNavigatorContext");
    }

    private void adjustCurrentProviderContext(boolean isLoading) {
        if (this.currentContentProvider != null) {
            if (isLoading) {
                this.currentContentProvider.setContext(0);
            } else {
                this.currentContentProvider.setContext(1);
            }
        }
    }

    public IFile getFile(Object object) {
        IFile file;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof FileProxyNode) {
            FileProxyNode proxy = (FileProxyNode)object;
            return proxy.getFile();
        }
        if (object instanceof EObjectProxyNode) {
            EObjectProxyNode proxy = (EObjectProxyNode)object;
            Object parent = this.getCurrentFileProxyManager().getParent(proxy);
            if (parent instanceof IContainer) {
                URI uri = proxy.getOriginatorURI();
                String path = uri.trimFragment().toString().substring("platform:/resource".length());
                Path filePath = new Path(path);
                return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)filePath);
            }
        }
        if (object instanceof Resource) {
            return EMFUtil.getWorkspaceFile((Resource)((Resource)object));
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eContainer() != null) {
                return null;
            }
            Resource resource = eObject.eResource();
            if (resource == null) {
                return null;
            }
            return EMFUtil.getWorkspaceFile((Resource)resource);
        }
        if (object instanceof IAdaptable && (file = (IFile)((IAdaptable)object).getAdapter(IFile.class)) != null) {
            return file;
        }
        return null;
    }

    public void setMonitoringResourceChange(boolean enabled) {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().setActive(enabled);
        }
    }

    public boolean isMonitoringResourceChange() {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().isActive();
        }
        return false;
    }

    protected void loadSettings() {
        super.loadSettings();
        this.setShowingEObjectChildren(this.getSettings().getBoolean(SET_SHOW_EOBJECT_CHILDREN));
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        try {
            this.currentViewIndex = this.getSettings().getInt(DIALOGSTORE_HTN_VIEW);
            if (this.currentViewIndex < 0 || this.currentViewIndex > 1) {
                this.currentViewIndex = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.currentViewIndex = 0;
        }
        int criteria = 1;
        try {
            criteria = this.getSettings().getInt(SET_SORTER_CRITERIA);
        }
        catch (NumberFormatException numberFormatException) {}
        NavigatorViewerSorter viewerSorter = new NavigatorViewerSorter((INavigator)this, criteria){
            private final Pattern EXECUTION_RESULT_FILE_NAME_PATTERN;
            private final String ARTIFICIAL_TIME_STAMP = "_1000000000000";
            {
                this.EXECUTION_RESULT_FILE_NAME_PATTERN = Pattern.compile("(\\S|\\s)+_\\d{13}");
                this.ARTIFICIAL_TIME_STAMP = "_1000000000000";
            }

            protected int compareCategories(Object e1, Object e2) {
                if (e1 instanceof TestNavigatorContentProvider.IProxyGroup) {
                    if (e2 instanceof TestNavigatorContentProvider.IProxyGroup) {
                        return ((TestNavigatorContentProvider.IProxyGroup)e1).getOrder() - ((TestNavigatorContentProvider.IProxyGroup)e2).getOrder();
                    }
                    return -1;
                }
                if (e2 instanceof TestNavigatorContentProvider.IProxyGroup) {
                    return 1;
                }
                return super.compareCategories(e1, e2);
            }

            public int category(Object element) {
                IResource res;
                if (element instanceof IResource) {
                    return super.category(element);
                }
                if (element instanceof IAdaptable && (res = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
                    return super.category((Object)res);
                }
                return super.category(element);
            }

            protected String getValue(Viewer viewer, Object object) {
                String type;
                String value = super.getValue(viewer, object);
                if (object instanceof IExecutionResultProxyNode) {
                    int resourceValueSeparatorIndex = value.indexOf("_+_");
                    if (resourceValueSeparatorIndex == -1) {
                        if (!this.EXECUTION_RESULT_FILE_NAME_PATTERN.matcher(value).matches()) {
                            value = value.concat("_1000000000000");
                        }
                    } else if (this.getCriteria() == 1) {
                        String name = value.substring(0, resourceValueSeparatorIndex);
                        if (!this.EXECUTION_RESULT_FILE_NAME_PATTERN.matcher(name).matches()) {
                            value = name.concat("_1000000000000").concat(value.substring(resourceValueSeparatorIndex));
                        }
                    } else {
                        String name = value.substring(resourceValueSeparatorIndex + "_+_".length());
                        if (!this.EXECUTION_RESULT_FILE_NAME_PATTERN.matcher(name).matches()) {
                            value = value.concat("_1000000000000");
                        }
                    }
                }
                if (object instanceof ITypedElementProxyNode && (type = ((ITypedElementProxyNode)object).getType()) != null) {
                    value = this.getCriteria() == 1 ? (value.endsWith("_+_") ? value.concat(type) : value.concat("_+_").concat(type)) : (value.startsWith("_+_") ? type.concat(value) : type.concat("_+_").concat(value));
                }
                return value;
            }
        };
        treeViewer.setSorter((ViewerSorter)viewerSorter);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!TestNavigator.this.isShowingEObjectChildren()) {
                    return !(parentElement instanceof EObject);
                }
                return true;
            }
        };
        treeViewer.addFilter(viewerFilter);
        this.resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider(false);
        FileProxyNodeCache.getInstance().addResourceListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        TestResourceChangeUpdater resourceChangeUpdater = new TestResourceChangeUpdater(this);
        this.resourceChangeUpdaterProvider.setResourceChangeUpdater((IResourceChangeUpdater)resourceChangeUpdater);
        this.updateTestNavigatorProvider(treeViewer);
    }

    private void updateTestNavigatorProvider(TreeViewer treeViewer) {
        if (this.currentViewIndex == 0) {
            if (this.resourceProv == null) {
                this.resourceProv = new ResourceTestNavigatorContentProvider(this);
            }
            this.currentContentProvider = this.resourceProv;
        } else {
            if (this.logicalProv == null) {
                this.logicalProv = new LogicalTestNavigatorContentProvider(this);
            }
            this.currentContentProvider = this.logicalProv;
        }
        this.adjustCurrentProviderContext(true);
        treeViewer.setContentProvider((IContentProvider)this.currentContentProvider);
        if (this.labelProv == null) {
            this.labelProv = new TestDecoratingLabelProvider(new TestNavigatorLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), this);
            treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProv);
        }
        this.adjustCurrentProviderContext(false);
    }

    protected boolean editorActivated(IEditorPart editor) {
        if (this.getViewer() == null) {
            return false;
        }
        IFile file = null;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            file = fileInput.getFile();
        } else {
            file = (IFile)input.getAdapter(IFile.class);
        }
        if (file != null) {
            this.selectReveal((ISelection)new StructuredSelection((Object)file));
            return true;
        }
        return false;
    }

    protected void linkToEditor(IStructuredSelection structuredSelection) {
        IFile file = this.getFile(structuredSelection.getFirstElement());
        if (file != null) {
            IWorkbenchPage page = this.getSite().getPage();
            if (page.getActiveEditor() != null) {
                IEditorInput input = page.getActiveEditor().getEditorInput();
                IFile editorsFile = null;
                editorsFile = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : (IFile)input.getAdapter(IFile.class);
                if (editorsFile != null && editorsFile.equals((Object)file)) {
                    return;
                }
            }
            IEditorPart editor = null;
            IEditorReference[] openEditors = page.getEditorReferences();
            try {
                int i = 0;
                while (i < openEditors.length) {
                    IEditorInput input = openEditors[i].getEditorInput();
                    IFile editorsFile = null;
                    editorsFile = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : (IFile)input.getAdapter(IFile.class);
                    if (editorsFile != null && editorsFile.equals((Object)file)) {
                        editor = openEditors[i].getEditor(false);
                        break;
                    }
                    ++i;
                }
            }
            catch (PartInitException e) {
                UiPlugin.logError(e);
            }
            if (editor != null && page.getActiveEditor() != editor) {
                page.bringToTop(editor);
            }
        }
    }

    public AbstractUIPlugin getPlugin() {
        return UiPlugin.getInstance();
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void createActions() {
        TestNavigatorActionGroup HTNActionGroup = new TestNavigatorActionGroup(this);
        this.setActionGroup(HTNActionGroup);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), HTNActionGroup.getRenameAction());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), HTNActionGroup.getCopyAction());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), HTNActionGroup.getPasteAction());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), HTNActionGroup.getRefreshAction());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.MOVE.getId(), HTNActionGroup.getMoveAction());
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager viewMenu = actionBars.getToolBarManager();
        if (HTNActionGroup != null && this.currentViewIndex == 1) {
            HTNActionGroup.getPasteAction().setEnabled(false);
            HTNActionGroup.getCopyAction().setEnabled(false);
        } else if (HTNActionGroup != null && this.currentViewIndex == 0) {
            HTNActionGroup.getPasteAction().setEnabled(true);
            HTNActionGroup.getCopyAction().setEnabled(true);
        }
        int i = 0;
        while (i < this.viewActions.length) {
            ToggleViewAction action = this.viewActions[i];
            viewMenu.add((IAction)action);
            action.setEnabled(true);
            action.setChecked(this.currentViewIndex == action.getViewerIndex());
            ++i;
        }
        viewMenu.add((IContributionItem)new Separator());
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IContributionItem)new Separator());
        int i2 = 0;
        while (i2 < this.viewActions.length) {
            ToggleViewAction action = this.viewActions[i2];
            menuManager.add((IAction)action);
            action.setEnabled(true);
            action.setChecked(this.currentViewIndex == action.getViewerIndex());
            ++i2;
        }
        menuManager.add((IContributionItem)new Separator());
    }

    public boolean isShowingFolders() {
        return this.showingFolders;
    }

    public void setShowingFolders(boolean enabled) {
        this.showingFolders = enabled;
        this.getSettings().put(SET_SHOW_FOLDERS, this.showingFolders);
        if (this.getViewer() == null) {
            return;
        }
        this.getViewer().refresh();
    }

    public boolean isShowingEObjectChildren() {
        return this.showingEObjectChildren;
    }

    public void setShowingEObjectChildren(boolean enabled) {
    }

    protected String getStatusLineMessage(IStructuredSelection structuredSelection) {
        if (structuredSelection.size() == 1) {
            AbstractProxy proxy;
            Object selection = structuredSelection.getFirstElement();
            if (selection instanceof IResource) {
                return ((IResource)selection).getFullPath().toString();
            }
            if (selection instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)selection;
                if (logicalFolder.getChildren().size() == 0) {
                    return logicalFolder.getName();
                }
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_LOG_FLD, (Object[])new String[]{logicalFolder.getName(), Integer.toString(logicalFolder.getChildren().size())});
            }
            if (selection instanceof CMNNamedElement) {
                CMNNamedElement namedElement = (CMNNamedElement)selection;
                String label = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)namedElement);
                IFile file = EMFUtil.getWorkspaceFile((EObject)namedElement);
                String filePath = "";
                if (file != null) {
                    filePath = file.getFullPath().toString();
                }
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_FILE_ELEM, (Object[])new String[]{label, filePath});
            }
            if (selection instanceof CMNNamedElementProxyNode && ((EObjectProxyNode)(proxy = (CMNNamedElementProxyNode)selection)).getUnderlyingResource() != null) {
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_FILE_ELEM, (Object[])new String[]{((CMNNamedElementProxyNode)proxy).getText(), ((EObjectProxyNode)proxy).getUnderlyingResource().getFullPath().toString()});
            }
            if (selection instanceof FileProxyNode) {
                proxy = (FileProxyNode)selection;
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_FILE_ELEM, (Object[])new String[]{((FileProxyNode)proxy).getText(), ((FileProxyNode)proxy).getUnderlyingResource().getFullPath().toString()});
            }
            if (selection instanceof Resource) {
                Resource resource = (Resource)selection;
                String label = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)resource);
                IFile file = EMFUtil.getWorkspaceFile((Resource)resource);
                String filePath = "";
                if (file != null) {
                    filePath = file.getFullPath().toString();
                }
                return NLS.bind((String)UiPluginResourceBundle.STS_LNE_FILE_ELEM, (Object[])new String[]{label, filePath});
            }
        }
        return super.getStatusLineMessage(structuredSelection);
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer treeViewer;
        IStructuredSelection selection;
        Object element;
        if (event.getViewer() == this.getTreeViewer() && (element = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IContainer && (treeViewer = this.getTreeViewer()).isExpandable(element)) {
            treeViewer.setExpandedState(element, !treeViewer.getExpandedState(element));
        }
    }

    protected IStructuredSelection convertToViewer(ISelection selection) {
        IStructuredSelection structuredSelection = super.convertToViewer(selection);
        if (structuredSelection.isEmpty()) {
            return structuredSelection;
        }
        ArrayList<Object> elements = new ArrayList<Object>(structuredSelection.size());
        for (Object object : structuredSelection) {
            if (object instanceof IFile) {
                EObject[] eObjects = EMFUtil.getEObjects(null, (IFile)((IFile)object));
                int j = 0;
                int maxj = eObjects.length;
                while (j < maxj) {
                    if (eObjects[j] instanceof CMNNamedElement) {
                        elements.add(eObjects[j]);
                    }
                    ++j;
                }
                continue;
            }
            if (object instanceof EObject) {
                EObject eObject = EMFUtil.getEObject(null, (EObject)((EObject)object), (boolean)false);
                if (eObject == null) continue;
                if (eObject.eContainer() == null) {
                    elements.add(eObject);
                    continue;
                }
                if (this.isShowingEObjectChildren()) {
                    elements.add(eObject);
                    continue;
                }
                elements.add(EcoreUtil.getRootContainer((EObject)eObject));
                continue;
            }
            elements.add(object);
        }
        return new StructuredSelection(elements);
    }

    public void handleChange(int type) {
        if (NavigatorViewerSorter.SORTER_TYPE == type) {
            this.getSettings().put(SET_SORTER_CRITERIA, ((NavigatorViewerSorter)this.getViewer().getSorter()).getCriteria());
            NavigatorActionGroup actionGroup = this.getActionGroup();
            if (actionGroup != null) {
                actionGroup.updateActionBars();
            }
        }
        super.handleChange(type);
    }

    public Object getInitialViewerInput() {
        return super.getInitialViewerInput();
    }

    protected TreeNavigatorFrameSource createFrameSource() {
        return new TestNavigatorFrameSource(this);
    }

    public void registerRootLogcalFolder(LogicalFolder logicalFolder) {
        if (logicalFolder != null && logicalFolder.getParent() == null) {
            if (this.rootLogicalFolders == null) {
                this.rootLogicalFolders = new ArrayList();
            }
            this.rootLogicalFolders.add(logicalFolder);
        }
    }

    public LogicalFolder getRootLogicalFolder(String name) {
        if (this.rootLogicalFolders != null && name != null) {
            for (LogicalFolder logicalFolder : this.rootLogicalFolders) {
                if (!name.equals(logicalFolder.getName())) continue;
                return logicalFolder;
            }
        }
        return null;
    }

    protected List loadElements(IMemento memento) {
        Object[] objects = super.loadElements(memento).toArray();
        ArrayList<Object> elements = new ArrayList<Object>(objects.length);
        int i = 0;
        int maxi = objects.length;
        while (i < maxi) {
            if (objects[i] instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)objects[i];
                Object parent = logicalFolder.getParent();
                if (parent == null) {
                    if ((logicalFolder = this.getRootLogicalFolder(logicalFolder.getName())) != null) {
                        elements.add(logicalFolder);
                    }
                } else if (parent instanceof EObject) {
                    EObject eObject = EMFUtil.getEObject(null, (EObject)((EObject)parent), (boolean)true);
                    if (eObject != null) {
                        LogicalFolder newLogicalFolder = new LogicalFolder((Object)eObject, logicalFolder.getName());
                        newLogicalFolder.setData(logicalFolder.getData());
                        newLogicalFolder.setDescription(logicalFolder.getDescription());
                        elements.add(newLogicalFolder);
                    }
                } else {
                    elements.add(logicalFolder);
                }
            } else if (objects[i] instanceof EObject) {
                EObject eObject = EMFUtil.getEObject(null, (EObject)((EObject)objects[i]), (boolean)true);
                if (eObject != null) {
                    elements.add(eObject);
                }
            } else if (objects[i] instanceof ResourceUtil.ResourceAdaptable) {
                Resource resource = ((ResourceUtil.ResourceAdaptable)objects[i]).getResource();
                if (resource != null && (resource = EMFUtil.getResource(null, (URI)resource.getURI(), (boolean)true)) != null) {
                    elements.add(resource);
                }
            } else {
                elements.add(objects[i]);
            }
            ++i;
        }
        return elements;
    }

    protected String getHelpContextId() {
        return String.valueOf(UiPlugin.getID()) + ".tnav0001";
    }

    public String getID() {
        return ID;
    }

    public boolean isVisibleResource(IResource resource) {
        return TestNavigator.getFiltersManager().isVisibleResource(resource);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer == null || !this.isLinkingEnabled()) {
            return;
        }
        if (part instanceof BaseEditorPart) {
            Object element = ((BaseEditorPart)part).getEditorObject();
            IProxyNode proxy = this.getCurrentFileProxyManager().getCorrespondingProxy(element);
            if (proxy != null) {
                treeViewer.setSelection((ISelection)new StructuredSelection((Object)proxy), true);
            }
        }
    }

    public void setView(int viewerIndex) {
        if (viewerIndex < this.viewActions.length && this.currentViewIndex != viewerIndex) {
            this.currentViewIndex = viewerIndex;
            this.updateTestNavigatorProvider((TreeViewer)this.getViewer());
            ((TreeViewer)this.getViewer()).refresh();
            this.updateActionStates();
            this.getSettings().put(DIALOGSTORE_HTN_VIEW, viewerIndex);
        }
    }

    private void updateActionStates() {
        int i = 0;
        while (i < this.viewActions.length) {
            ToggleViewAction action;
            action.setChecked(this.currentViewIndex == (action = this.viewActions[i]).getViewerIndex());
            ++i;
        }
        TestNavigatorActionGroup HTNActionGroup = (TestNavigatorActionGroup)this.getActionGroup();
        if (HTNActionGroup != null && this.currentViewIndex == 1) {
            HTNActionGroup.getPasteAction().setEnabled(false);
            HTNActionGroup.getCopyAction().setEnabled(false);
        } else if (HTNActionGroup != null && this.currentViewIndex == 0) {
            HTNActionGroup.getPasteAction().setEnabled(true);
            HTNActionGroup.getCopyAction().setEnabled(true);
        }
    }

    public int getCurrentViewIndex() {
        return this.currentViewIndex;
    }

    public void nodeChanged(Object node) {
        this.currentContentProvider.getProxyNodeListener().nodeChanged(node);
        this.refresh(node);
    }

    public void nodesChanged() {
        this.currentContentProvider.getProxyNodeListener().nodesChanged();
        this.refresh(null);
    }

    void refresh(Object node) {
        Display.getDefault().asyncExec((Runnable)new Refresher(node));
    }

    public static Iterator getAllInstancesIterator() {
        if (testNavigatorByWorkbenchWindow == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return testNavigatorByWorkbenchWindow.values().iterator();
    }

    public void selectReveal(ISelection selection) {
        IProxyNode proxy;
        Object selObj;
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1 && (selObj = sel.getFirstElement()) instanceof IFile && (proxy = this.getProxy((IFile)selObj)) != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)proxy), true);
            return;
        }
        super.selectReveal(selection);
    }

    private IProxyNode getProxy(IFile file) {
        IFileProxyManager proxyManager = this.getCurrentFileProxyManager();
        switch (this.currentViewIndex) {
            case 1: {
                IProject project = file.getProject();
                if (project != null) {
                    this.currentContentProvider.getChildren(project);
                }
                return proxyManager.getProxy(file, null);
            }
            case 0: {
                IProxyNode proxy = proxyManager.getProxy(file, file.getParent());
                if (proxyManager.getParent(proxy) == null) {
                    proxyManager.cacheProxy(file, proxy);
                }
                return proxy;
            }
        }
        return null;
    }

    public static String getRegisteredTypeName(String type) {
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        IAssociationDescriptor descriptor = associationMapping.getDefaultAssociationDescriptor(type);
        if (descriptor != null) {
            return descriptor.getName();
        }
        return "[Invalid Descriptor]";
    }

    public FixedSizeJobPool getJobPool() {
        if (this.jobPool == null) {
            this.jobPool = new FixedSizeJobPool(3);
        }
        return this.jobPool;
    }

    private static class AllInstancesRefresher
    implements IProxyNodeListener {
        private AllInstancesRefresher() {
        }

        public void nodeChanged(Object node) {
            Iterator it = TestNavigator.getAllInstancesIterator();
            while (it.hasNext()) {
                ((TestNavigator)it.next()).nodeChanged(node);
            }
        }
    }

    class Refresher
    implements Runnable {
        private Object node;

        public Refresher(Object node) {
            this.node = node;
        }

        public void run() {
            StructuredViewer viewer = TestNavigator.this.getViewer();
            if (viewer != null) {
                if (this.node != null) {
                    viewer.refresh(this.node);
                } else {
                    viewer.refresh();
                }
            }
        }
    }

    private static class TypeProviderContext
    implements ITypeProviderContext {
        private IProxyNodeListener refresher;

        private TypeProviderContext() {
        }

        public IFileProxyManager getFileProxyManager() {
            return LogicalTestNavigatorContentProvider.getSharedFileProxyManager();
        }

        public IProxyNodeListener getProxyNodeListener() {
            if (this.refresher == null) {
                this.refresher = new AllInstancesRefresher();
            }
            return this.refresher;
        }

        public boolean isStaticView() {
            return false;
        }
    }
}

