/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.dialog.ListDialog;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.editor.HyadesEditorPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors = EditorUtil.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!EditorUtil.saveAllDirtyEditors(shell, dirtyEditors)) {
            return false;
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                int i = 0;
                while (true) {
                    if (i >= dirtyEditors.length) {
                        if (UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) break;
                        return false;
                    }
                    IEditorPart part = dirtyEditors[i];
                    if (part instanceof HyadesEditorPart) {
                        HyadesEditorPart hyadesEditor = (HyadesEditorPart)part;
                        hyadesEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                        IEditorExtension extension = hyadesEditor.getEditorExtension();
                        if (extension instanceof ISynchronizedEditorAdapter) {
                            ((ISynchronizedEditorAdapter)extension).reload();
                        }
                    }
                    ++i;
                }
            }
            finally {
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
            }
        }
        catch (CoreException e) {
            UiPlugin.logError("Unable to save modified resources", e);
            return false;
        }
    }

    private static boolean saveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        ListDialog dialog = new ListDialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                1.applyDialogFont((Control)result);
                return result;
            }
        };
        dialog.setTitle(ActionMessages.SAVE_ALL_DIALOG_NAME);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(EditorUtil.createDialogLabelProvider());
        dialog.setMessage(ActionMessages.SAVE_ALL_DIALOG_MESSAGE);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        return dialog.open() == 0;
    }

    private static ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }

    private static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorInput input;
                    IEditorPart ep = editors[z];
                    if (ep instanceof HyadesEditorPart && !inputs.contains(input = ep.getEditorInput())) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }
}

