/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class ExecutionFilterDialog
extends Dialog
implements Listener {
    private ExecutionNavigator executionExplorer;
    private Button okButton;
    private Button showRunningButton;
    private Button showFinishedButton;
    private IPreferenceStore store;

    public ExecutionFilterDialog(ExecutionNavigator executionExplorer) {
        super(executionExplorer.getSite().getShell());
        this.executionExplorer = executionExplorer;
        this.store = UiPlugin.getInstance().getPreferenceStore();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UiPluginResourceBundle.EXEC_DLG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFilterOptions(composite);
        this.setCurrentFilter();
        this.adjustOptions();
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(UiPlugin.getID()) + ".enav0005");
        return composite;
    }

    private Control createFilterOptions(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 5;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        Group composite = new Group(parent, 0);
        composite.setText(UiPluginResourceBundle.EXEC_DLG_DESC);
        composite.setLayout((Layout)layout);
        GridData data = GridDataUtil.createFill();
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.showRunningButton = new Button((Composite)composite, 32);
        this.showRunningButton.setText(UiPluginResourceBundle.EXEC_DLG_SHOW_RUN);
        this.showRunningButton.addListener(13, (Listener)this);
        this.showFinishedButton = new Button((Composite)composite, 32);
        this.showFinishedButton.setText(UiPluginResourceBundle.EXEC_DLG_SHOW_FINISHED);
        this.showFinishedButton.addListener(13, (Listener)this);
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.showRunningButton, String.valueOf(UiPlugin.getID()) + ".enav0006");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.showFinishedButton, String.valueOf(UiPlugin.getID()) + ".enav0007");
        return parent;
    }

    private void setCurrentFilter() {
        int pref = this.store.getInt("execFilter");
        boolean showRunning = (pref & 1) == 1;
        boolean showFinished = (pref & 2) == 2;
        this.showRunningButton.setSelection(showRunning);
        this.showFinishedButton.setSelection(showFinished);
    }

    protected int getShowRunningFinished() {
        int pref = 0;
        if (this.showRunningButton.getSelection()) {
            pref |= 1;
        }
        if (this.showFinishedButton.getSelection()) {
            pref |= 2;
        }
        return pref;
    }

    protected void okPressed() {
        int pref = this.getShowRunningFinished();
        this.store.setValue("execFilter", pref);
        this.executionExplorer.getTreeViewer().refresh();
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(false);
        }
        return button;
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            this.adjustOptions();
        }
    }

    private boolean adjustOptions() {
        int filter = this.getShowRunningFinished();
        if (this.okButton != null) {
            boolean enabled = this.store.getInt("execFilter") != filter;
            this.okButton.setEnabled(enabled);
        }
        return false;
    }
}

