/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.action.EditorUtil;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.IPasterExtended;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteRefactoringWizard;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;

public class FileAndFolderPaster
implements IPasterExtended {
    private LinkedList folders = new LinkedList();
    private LinkedList proxies = new LinkedList();
    private LinkedList externalFiles = new LinkedList();
    private Clipboard clipboard = null;
    private Shell shell = null;

    public boolean isPasteAllowedFor(Clipboard clipboard, Object selection) {
        return selection instanceof IContainer;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    private void sortClipboardElements(Object selection) {
        IResource[] res;
        this.folders.clear();
        this.proxies.clear();
        this.externalFiles.clear();
        IContainer container = null;
        if (selection instanceof IContainer) {
            container = (IContainer)selection;
        }
        if ((res = this.getResourceFromClipboard(container)) == null) {
            return;
        }
        int i = 0;
        while (i < res.length) {
            IResource a;
            Object o;
            if (res[i] instanceof IFile) {
                IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy((IFile)res[i]);
                if (proxy != null) {
                    this.proxies.add(proxy);
                }
            } else if (res[i] instanceof IAdaptable && (o = (a = res[i]).getAdapter(IFolder.class)) != null) {
                this.folders.add((IFolder)o);
            }
            ++i;
        }
    }

    private IResource[] getResourceFromClipboard(IContainer container) {
        final IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])FileAndFolderPaster.this.clipboard.getContents((Transfer)resTransfer);
                if (clipboardData[0] == null) {
                    FileTransfer transfer = FileTransfer.getInstance();
                    String[] res = (String[])FileAndFolderPaster.this.clipboard.getContents((Transfer)transfer);
                    if (res != null) {
                        IResource[] res2 = new IResource[res.length];
                        int i = 0;
                        while (i < res.length) {
                            Path path = new Path(res[i]);
                            res2[i] = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                            if (res2[i] == null) {
                                FileAndFolderPaster.this.externalFiles.add(res[i]);
                            }
                            ++i;
                        }
                        clipboardData[0] = res2;
                    }
                }
            }
        });
        return clipboardData[0];
    }

    private boolean canActivate(Shell shell) {
        return EditorUtil.saveEditors(shell);
    }

    public boolean performPaste(Clipboard clipboard, Object selection) {
        if (!this.canActivate(this.shell)) {
            return false;
        }
        this.clipboard = clipboard;
        this.sortClipboardElements(selection);
        PasteRefactoring refactoring = new PasteRefactoring(this.folders, this.proxies, this.externalFiles);
        PasteRefactoringWizard wizard = new PasteRefactoringWizard(refactoring, selection);
        wizard.setDefaultPageTitle(ActionMessages.PASTE_ACTION_NAME);
        wizard.setNeedsProgressMonitor(true);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(this.shell, "");
        }
        catch (InterruptedException e) {
            UiPlugin.logError(e);
        }
        return true;
    }
}

