/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.internal.navigator.ResourceTestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ProxyNodeTransfer;
import org.eclipse.hyades.test.ui.navigator.actions.IPaster;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class FileProxyInContainerPaste
implements IPaster {
    private IResource[] getResourceFromClipboard(final Clipboard clipboard) {
        final IResource[][] clipboardData = new IResource[1][];
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])clipboard.getContents((Transfer)resTransfer);
            }
        });
        return clipboardData[0];
    }

    public boolean isPasteAllowedFor(Clipboard clipboard, Object selection) {
        if (selection instanceof IContainer) {
            ProxyNodeTransfer proxyTransfer = ProxyNodeTransfer.getInstance();
            IProxyNode[] clipContent = (IProxyNode[])clipboard.getContents((Transfer)proxyTransfer);
            if (clipContent == null) {
                return false;
            }
            int i = 0;
            while (i < clipContent.length) {
                IProxyNode proxy = clipContent[i];
                Object parent = proxy.getParent();
                if (parent instanceof FileProxyManager.IUnboundedParent) {
                    parent = ResourceTestNavigatorContentProvider.getSharedFileProxyManager().getParent(proxy);
                }
                if (!(proxy instanceof FileProxyNode) && !(parent instanceof IContainer)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean performPaste(Clipboard clipboard, Object selection) {
        IResource[] res = this.getResourceFromClipboard(clipboard);
        if (res != null && res.length > 0) {
            boolean doable = true;
            int i = 0;
            while (i < res.length) {
                doable &= res[i].getType() == 2 || res[i].getType() == 1;
                ++i;
            }
            IResource[] copied = new IResource[]{};
            if (doable) {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(Display.getCurrent().getActiveShell());
                copied = operation.copyResources(res, (IContainer)selection);
            }
            return doable && copied.length > 0;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null) {
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(Display.getCurrent().getActiveShell());
            operation.copyFiles(fileData, (IContainer)selection);
            return true;
        }
        return false;
    }
}

