/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.action.EditorUtil;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveRefactoringWizard;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeMover;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class MoveAction
extends SelectionListenerAction
implements IDisposable {
    private Shell shell;
    private LinkedList folders;
    private LinkedList proxies;
    private boolean isResourceNav;

    public MoveAction(Shell shell) {
        super(ActionMessages.MOVE_ACTION_NAME);
        this.shell = shell;
        this.folders = new LinkedList();
        this.proxies = new LinkedList();
        this.isResourceNav = false;
    }

    public void run() {
        if (!this.canActivate(this.shell)) {
            return;
        }
        MoveRefactoring refactoring = new MoveRefactoring(this.folders, this.proxies);
        MoveRefactoringWizard wizard = new MoveRefactoringWizard(refactoring);
        wizard.setDefaultPageTitle(ActionMessages.MOVE_ACTION_NAME);
        wizard.setNeedsProgressMonitor(true);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(this.shell, "");
        }
        catch (InterruptedException e) {
            UiPlugin.logError(e);
        }
    }

    private boolean canActivate(Shell shell) {
        return EditorUtil.saveEditors(shell);
    }

    private void sortSelectedElements() {
        this.folders.clear();
        this.proxies.clear();
        IStructuredSelection sel = this.getStructuredSelection();
        for (Object o : sel) {
            IAdaptable a;
            if (o instanceof IProxyNode) {
                this.proxies.add(o);
                continue;
            }
            if (o instanceof IFile) {
                IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy((IFile)o);
                if (proxy == null) continue;
                this.proxies.add(proxy);
                continue;
            }
            if (!(o instanceof IAdaptable) || (o = (a = (IAdaptable)o).getAdapter(IFolder.class)) == null) continue;
            this.folders.add((IFolder)o);
        }
    }

    public void dispose() {
    }

    public void selectionChanged(IStructuredSelection structuredSelection, boolean isResourceTestNav) {
        this.isResourceNav = isResourceTestNav;
        super.selectionChanged(structuredSelection);
        this.sortSelectedElements();
    }

    public boolean isApplicableForSelection() {
        String name;
        if (!this.isResourceNav) {
            return false;
        }
        if (this.folders.size() == 0 && !this.areProxiesMovable()) {
            return false;
        }
        if (this.folders.isEmpty() && this.proxies.isEmpty()) {
            return false;
        }
        ArrayList<String> allNames = new ArrayList<String>();
        Iterator it = this.folders.iterator();
        while (it.hasNext()) {
            name = ((IFolder)it.next()).getName();
            if (allNames.contains(name)) {
                return false;
            }
            allNames.add(name);
        }
        it = this.proxies.iterator();
        while (it.hasNext()) {
            name = ((IProxyNode)it.next()).getUnderlyingResource().getName();
            if (allNames.contains(name)) {
                return false;
            }
            allNames.add(name);
        }
        return true;
    }

    private boolean areProxiesMovable() {
        for (IProxyNode proxy : this.proxies) {
            if (proxy.getAdapter(IFile.class) != null && proxy.getAdapter(IProxyNodeMover.class) != null) continue;
            return false;
        }
        return true;
    }
}

