/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NewObjectAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.NewWizardMenu;

public class NewActionGroup
extends NavigatorActionGroup {
    private NewObjectAction newTestSuiteAction;
    private NewObjectAction newDeploymentAction;
    private NewObjectAction newHyadesObjectAction;

    public NewActionGroup(TreeNavigator testNavigator) {
        super((INavigator)testNavigator);
    }

    protected void createActions() {
        this.newTestSuiteAction = new NewObjectAction(this.getNavigator().getSite().getWorkbenchWindow());
        this.newTestSuiteAction.setText(UiPluginResourceBundle.LBL_TST_SUITE);
        this.newTestSuiteAction.setToolTipText(this.newTestSuiteAction.getText());
        this.newTestSuiteAction.setWizardTitle(UiPluginResourceBundle.WIZ_TST_SUITE_TTL);
        this.newTestSuiteAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new/testSuite");
        this.newDeploymentAction = new NewObjectAction(this.getNavigator().getSite().getWorkbenchWindow());
        this.newDeploymentAction.setText(UiPluginResourceBundle.LBL_DEPLOYMENT);
        this.newDeploymentAction.setToolTipText(this.newDeploymentAction.getText());
        this.newDeploymentAction.setWizardTitle(UiPluginResourceBundle.WIZ_DEPLOY_TTL);
        this.newDeploymentAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new/testElements");
        this.newHyadesObjectAction = new NewObjectAction(this.getNavigator().getSite().getWorkbenchWindow());
        this.newHyadesObjectAction.setText(UiPluginResourceBundle.WIZ_TST_OBJ_ACT);
        this.newHyadesObjectAction.setWizardTitle(UiPluginResourceBundle.WIZ_TST_OBJ_TTL);
        this.newHyadesObjectAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new");
        this.newHyadesObjectAction.setToolTipText(this.newHyadesObjectAction.getText());
    }

    public void fillContextMenu(IMenuManager menu) {
        LogicalFolder logicalFolder;
        Object selection;
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (this.getNavigator().isShowingFolders()) {
            if (!this.hasLogicalFolder(structuredSelection)) {
                MenuManager newMenu = new MenuManager(UiPluginResourceBundle.LBL_NEW, "group.new.content");
                menu.appendToGroup("group.new", (IContributionItem)newMenu);
                new NewWizardMenu((IMenuManager)newMenu, this.getNavigator().getSite().getWorkbenchWindow(), false);
                newMenu.insert(0, (IContributionItem)new ActionContributionItem((IAction)this.newHyadesObjectAction));
                newMenu.insert(1, (IContributionItem)new Separator("additions"));
            }
        } else if (structuredSelection.size() == 1 && (selection = structuredSelection.getFirstElement()) instanceof LogicalFolder && (logicalFolder = (LogicalFolder)selection).getParent() == null) {
            MenuManager newMenu = new MenuManager(UiPluginResourceBundle.LBL_NEW);
            menu.appendToGroup("group.new", (IContributionItem)newMenu);
            String name = logicalFolder.getName();
            if (TestWorkbenchAdapter.TEST_SUITE_LOGICAL_FOLDER_NAME.equals(name)) {
                newMenu.add((IAction)this.newTestSuiteAction);
            } else if (TestWorkbenchAdapter.DEPLOYMENT_LOGICAL_FOLDER_NAME.equals(name)) {
                newMenu.add((IAction)this.newDeploymentAction);
            }
        }
    }

    protected boolean hasLogicalFolder(IStructuredSelection structuredSelection) {
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof LogicalFolder)) continue;
            return true;
        }
        return false;
    }
}

