/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.actions.IPaster;
import org.eclipse.swt.dnd.Clipboard;

public class PasteExtensionManager {
    private static PasteExtensionManager instance;
    private List strictPasters = new LinkedList();
    private List simplePasters = new LinkedList();

    public static PasteExtensionManager getInstance() {
        if (instance == null) {
            instance = new PasteExtensionManager();
        }
        return instance;
    }

    private PasteExtensionManager() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorPasteExtension");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element = members[i];
                if ("paster".equals(element.getName())) {
                    String target = element.getAttribute("target");
                    boolean strict = Boolean.valueOf(element.getAttribute("strict"));
                    this.addPasteExtension(target, element, strict);
                }
                ++i;
            }
        }
    }

    private void addPasteExtension(String target, IConfigurationElement element, boolean strict) {
        PasterExtensionInfo info = new PasterExtensionInfo(target, strict, element);
        if (strict) {
            this.strictPasters.add(info);
        } else {
            this.simplePasters.add(info);
        }
    }

    public boolean isPasteAllowedFor(Clipboard clipboard, Object selection) {
        IPaster[] pasters = this.getPasters(selection);
        int i = 0;
        while (i < pasters.length) {
            IPaster paster = pasters[i];
            if (paster != null && paster.isPasteAllowedFor(clipboard, selection)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPaster[] getPasters(Object selection) {
        if (selection != null) {
            LinkedList<IPaster> pasters = new LinkedList<IPaster>();
            Class<?> target = selection.getClass();
            for (PasterExtensionInfo info : this.strictPasters) {
                if (target != info.getTarget()) continue;
                pasters.add(info.getPaster());
            }
            for (PasterExtensionInfo info : this.simplePasters) {
                if (!info.getTarget().isAssignableFrom(target)) continue;
                pasters.add(info.getPaster());
            }
            return pasters.toArray(new IPaster[pasters.size()]);
        }
        return new IPaster[0];
    }

    static class PasterExtensionInfo {
        private boolean strict;
        private Class target;
        private IPaster paster;
        private IConfigurationElement element;

        public PasterExtensionInfo(String target, boolean strict, IConfigurationElement element) {
            this.strict = strict;
            try {
                this.target = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier()).loadClass(target);
            }
            catch (ClassNotFoundException e) {
                UiPlugin.logError(e);
            }
            this.element = element;
            this.paster = null;
        }

        public IPaster getPaster() {
            if (this.paster == null) {
                try {
                    this.paster = (IPaster)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    UiPlugin.logError(e);
                }
            }
            return this.paster;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public Class getTarget() {
            return this.target;
        }
    }
}

