/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.action.EditorUtil;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RenameRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer2;
import org.eclipse.hyades.test.ui.navigator.actions.RenamerUIStatus;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RenameAction
extends Action
implements IDisposable {
    private IStructuredSelection selection;
    protected Composite textEditorParent;
    private TreeEditor treeEditor;
    protected Tree navigatorTree;
    protected Text textEditor;
    private TextActionHandler textActionHandler;
    protected TreeNavigator navigator;
    protected IContainer renamedResource;

    public RenameAction(TreeNavigator treeNav) {
        super(TestNavigatorMessages.RenameAction_ActionName);
        this.navigator = treeNav;
        this.navigatorTree = treeNav.getTreeViewer().getTree();
        this.treeEditor = new TreeEditor(this.navigatorTree);
        this.renamedResource = null;
    }

    public void dispose() {
        this.selection = null;
        this.disposeTextWidget();
    }

    public boolean isApplicableForSelection() {
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        Object objSelected = this.selection.getFirstElement();
        if (objSelected instanceof IContainer) {
            return ((IContainer)objSelected).isAccessible();
        }
        if (objSelected instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)objSelected;
            IProxyNodeRenamer2 renamer2 = (IProxyNodeRenamer2)proxy.getAdapter(IProxyNodeRenamer2.class);
            if (renamer2 != null) {
                return true;
            }
            this.oldActionValidation(proxy);
        }
        return false;
    }

    private boolean oldActionValidation(IProxyNode proxy) {
        IProxyNodeRenamer renamer = (IProxyNodeRenamer)proxy.getAdapter(IProxyNodeRenamer.class);
        if (renamer != null) {
            return renamer.isApplicableFor();
        }
        return false;
    }

    private Composite createParent() {
        Composite result = new Composite((Composite)this.navigatorTree, 0);
        TreeItem[] selectedItems = this.navigatorTree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void createTextEditor(final IProxyNodeRenamer renamer) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        this.textEditorParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameAction.this.textEditor.getSize();
                Point parentSize = RenameAction.this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.navigatorTree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameAction.this.textEditorParent.getSize();
                RenameAction.this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                RenameAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameAction.this.performRename(renamer, RenameAction.this.textEditor.getText());
                        RenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameAction.this.disposeTextWidget();
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    protected void performRename(final IProxyNodeRenamer renamer, final String newName) {
        Runnable query = new Runnable(){

            public void run() {
                if (renamer == null) {
                    this.moveResource((IResource)RenameAction.this.renamedResource, newName);
                } else {
                    boolean shouldRefresh = renamer.performRename(newName);
                    if (shouldRefresh) {
                        RenameAction.this.navigator.getTreeViewer().refresh();
                    }
                }
                if (RenameAction.this.navigatorTree != null && !RenameAction.this.navigatorTree.isDisposed()) {
                    RenameAction.this.navigatorTree.setFocus();
                    TreeItem[] items = RenameAction.this.navigatorTree.getItems();
                    this.findItem(newName, items);
                }
            }

            private void moveResource(final IResource res, String name) {
                final IPath newPath = res.getFullPath().removeLastSegments(1).append(name);
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            res.move(newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, (IRunnableWithProgress)op);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {}
            }

            private boolean findItem(String name, TreeItem[] items) {
                int i = 0;
                while (i < items.length) {
                    if (items[i].getText().equals(name)) {
                        RenameAction.this.navigator.selectReveal((ISelection)new StructuredSelection(items[i].getData()));
                        return true;
                    }
                    if (items[i].getItemCount() > 0 && this.findItem(name, items[i].getItems())) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        this.navigatorTree.getShell().getDisplay().asyncExec(query);
    }

    protected void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    private void getNewNameInline(String oldName, IProxyNodeRenamer renamer) {
        if (this.textEditorParent == null) {
            this.createTextEditor(renamer);
        }
        this.textEditor.setText(oldName);
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    public void run() {
        Object objSelected = this.selection.getFirstElement();
        if (objSelected instanceof IContainer) {
            this.renamedResource = (IContainer)objSelected;
            this.preformContainerRefactoringRename(this.renamedResource);
        } else if (objSelected instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)objSelected;
            IProxyNodeRenamer2 renamer2 = (IProxyNodeRenamer2)proxy.getAdapter(IProxyNodeRenamer2.class);
            if (renamer2 != null) {
                this.performProxyRefactoringRename(proxy);
            } else {
                IReferencerProxyNode ref = (IReferencerProxyNode)proxy.getAdapter(IReferencerProxyNode.class);
                if (ref != null) {
                    this.performProxyRefactoringRename(proxy);
                } else {
                    this.performOldRename(proxy);
                }
            }
        }
    }

    private void performOldRename(IProxyNode proxy) {
        IProxyNodeRenamer renamer = (IProxyNodeRenamer)proxy.getAdapter(IProxyNodeRenamer.class);
        if (renamer != null) {
            RenamerUIStatus status = renamer.performUserInteraction(proxy.getText());
            switch (status.getStatus()) {
                case 0: {
                    this.performRename(renamer, status.getNewName());
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.getNewNameInline(proxy.getText(), renamer);
                }
            }
        }
    }

    private void preformContainerRefactoringRename(IContainer container) {
        RenameRefactoring refactoring = new RenameRefactoring(container);
        this.performRefactoringRename(refactoring, container.getName(), container.getParent());
    }

    private void performProxyRefactoringRename(IProxyNode proxy) {
        RenameRefactoring refactoring = new RenameRefactoring(proxy);
        this.performRefactoringRename(refactoring, proxy.getText(), proxy.getUnderlyingResource().getParent());
    }

    private void performRefactoringRename(RenameRefactoring refactoring, String oldName, IContainer parent) {
        Shell shell = Display.getCurrent().getActiveShell();
        if (!this.canActivate(shell)) {
            return;
        }
        RenameRefactoringWizard wizard = new RenameRefactoringWizard(refactoring, oldName, parent);
        wizard.setDefaultPageTitle(ActionMessages.RENAME_ACTION_NAME);
        wizard.setNeedsProgressMonitor(true);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(shell, "");
        }
        catch (InterruptedException e) {
            UiPlugin.logError(e);
        }
    }

    private boolean canActivate(Shell shell) {
        return EditorUtil.saveEditors(shell);
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        this.selection = structuredSelection;
    }

    class RenameRefactoringNewNameInputPage
    extends UserInputWizardPage {
        private RenameRefactoring refactoring;
        private Text nameText;
        private String oldName;
        private IContainer parentContainer;
        private String newName;

        public RenameRefactoringNewNameInputPage(RenameRefactoring refactoring, String oldName, IContainer parentContainer) {
            super("");
            this.newName = null;
            this.parentContainer = parentContainer;
            this.oldName = oldName;
            this.refactoring = refactoring;
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            result.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(result, 0);
            label.setText(ActionMessages.RENAME_NEW_NAME_LABEL);
            this.nameText = new Text(result, 2052);
            this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.nameText.setText(this.oldName);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RenameRefactoringNewNameInputPage.this.newName = RenameRefactoringNewNameInputPage.this.nameText.getText();
                    RenameRefactoringNewNameInputPage.this.refactoring.setNewName(RenameRefactoringNewNameInputPage.this.newName);
                    RenameRefactoringNewNameInputPage.this.setPageComplete(RenameRefactoringNewNameInputPage.this.isPageComplete());
                }
            });
            this.nameText.selectAll();
            Dialog.applyDialogFont((Control)result);
        }

        public boolean isPageComplete() {
            if (RenameAction.this.selection == null || RenameAction.this.selection.isEmpty()) {
                this.setMessage(null);
                this.setErrorMessage(RefactoringMessages.MISSING_RESOURCE);
                return false;
            }
            if (this.newName == null || this.newName.trim().length() == 0) {
                if (this.newName != null) {
                    this.setMessage(RefactoringMessages.MISSING_NAME, 2);
                    this.setErrorMessage(null);
                }
                return false;
            }
            if (this.newName.equals(this.oldName)) {
                this.setMessage(null);
                this.setErrorMessage(RefactoringMessages.DUPLICATE_NAME);
                return false;
            }
            this.setMessage(null);
            switch (TestUIUtil.validateResourcePath(this.newName, this.parentContainer)) {
                case 0: {
                    this.setErrorMessage(null);
                    return true;
                }
                case 2: 
                case 5: {
                    this.setErrorMessage(RefactoringMessages.INVALID_NAME);
                    return false;
                }
                case 1: 
                case 4: {
                    this.setErrorMessage(RefactoringMessages.LONG_NAME);
                    return false;
                }
                case 3: 
                case 6: {
                    this.setErrorMessage(RefactoringMessages.DUPLICATE_NAME);
                    return false;
                }
            }
            this.setErrorMessage(RefactoringMessages.MISSING_RESOURCE);
            return true;
        }
    }

    private class RenameRefactoringWizard
    extends RefactoringWizard {
        private RenameRefactoringNewNameInputPage page;

        private RenameRefactoringWizard(RenameRefactoring refactoring, String name, IContainer parent) {
            super((Refactoring)refactoring, 4);
            this.page = new RenameRefactoringNewNameInputPage(refactoring, name, parent);
        }

        protected void addUserInputPages() {
            this.addPage((IWizardPage)this.page);
        }
    }
}

