/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.runtime.Assert;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.internal.editor.HyadesEditorPart;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ToggleLinkingAction
extends NavigatorAction {
    public ToggleLinkingAction(INavigator navigator, String label) {
        super(navigator, label);
        Assert.isLegal((boolean)(navigator instanceof TestNavigator));
        this.setToolTipText(label);
        this.setChecked(navigator.isLinkingEnabled());
    }

    public void run() {
        INavigator navigator = this.getNavigator();
        boolean isChecked = this.isChecked();
        navigator.setLinkingEnabled(isChecked);
        if (!isChecked) {
            return;
        }
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof HyadesEditorPart) {
            Object elem = ((HyadesEditorPart)editorPart).getEditorObject();
            IProxyNode proxy = ((TestNavigator)navigator).getCurrentFileProxyManager().getCorrespondingProxy(elem);
            if (proxy != null) {
                navigator.selectReveal((ISelection)new StructuredSelection((Object)proxy));
            }
        }
    }
}

