/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTypeProviderProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.util.IDisposable;

public class DefaultTypeProvider
implements ITypeProvider,
IResourceChangeListener,
IDisposable {
    private Map cache = Collections.synchronizedMap(new HashMap());
    private IProxyNodeListener refresher;
    private IFileProxyManager fileProxyManager;

    public DefaultTypeProvider() {
        FileProxyNodeCache.getInstance().addResourceListener(this);
    }

    public void init(ITypeProviderContext context) {
        this.fileProxyManager = context.getFileProxyManager();
        this.refresher = context.getProxyNodeListener();
    }

    public ITypeProviderProxyNode get(IProject project, String type) {
        if (!project.exists()) {
            return null;
        }
        ITypeProviderProxyNode proxy = (ITypeProviderProxyNode)this.cache.get(project);
        if (proxy == null) {
            proxy = new DefaultTypeProviderProxyNode(project, this.fileProxyManager, type, project);
            this.cache.put(project, proxy);
        }
        return proxy.getChildren().length > 0 ? proxy : null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta resDelta = event.getDelta();
        IResourceDelta[] affectedProjects = resDelta.getAffectedChildren();
        int i = 0;
        while (i < affectedProjects.length) {
            IProxyNode lowestChanged = null;
            IResourceDelta delta = affectedProjects[i];
            IProject project = (IProject)delta.getResource();
            DefaultTypeProviderProxyNode proxy = (DefaultTypeProviderProxyNode)this.cache.get(project);
            if (delta.getKind() == 2) {
                this.cache.remove(project);
            } else if (delta.getKind() == 4) {
                if (proxy != null) {
                    int previousChildrenCount = proxy.getChildren().length;
                    lowestChanged = proxy.resourceChanged(delta);
                    if (lowestChanged == proxy) {
                        int newChildrenCount = proxy.getChildren().length;
                        if ((previousChildrenCount == 0 || newChildrenCount == 0) && previousChildrenCount != newChildrenCount) {
                            lowestChanged = project;
                        }
                    }
                }
                if (lowestChanged != null) {
                    this.refresher.nodeChanged(lowestChanged);
                }
            }
            ++i;
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public void dispose() {
        FileProxyNodeCache.getInstance().removeResourceListener(this);
    }
}

