/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.Proxy;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

public class FileProxyManager
implements IFileProxyManager {
    private Map parents = Collections.synchronizedMap(new HashMap());
    private Map parentsToCache = Collections.synchronizedMap(new HashMap());
    private FileProxyNodeCache fileProxyNodeCache = FileProxyNodeCache.getInstance();
    private static final ReferenceTypeRegistry factory = ReferenceTypeRegistry.getInstance();
    private static final ReferenceRegistry registry = ReferenceRegistry.getInstance();

    public IProxyNode getProxy(IFile file, Object parent) {
        IProxyNode proxy = this.fileProxyNodeCache.getProxy(file);
        if (parent != null) {
            this.parentsToCache.put(proxy, parent);
        }
        return proxy;
    }

    public void cacheProxy(IFile file, IProxyNode newProxy) {
        Object parent;
        if (newProxy != null && (parent = this.parentsToCache.remove(newProxy)) != null) {
            this.parents.put(newProxy, parent);
        }
    }

    public boolean isaCachedFile(IFile file) {
        return this.fileProxyNodeCache.isCached(file);
    }

    public IProxyNode updateProxy(IFile file, Object parent) {
        this.cleanUpOutdatedReferences(file);
        IProxyNode proxy = this.fileProxyNodeCache.createProxy(file);
        if (parent != null) {
            this.parentsToCache.put(proxy, parent);
        }
        return proxy;
    }

    private void cleanUpOutdatedReferences(IFile file) {
        Set allType = registry.getReferenceTypes(file);
        if (allType == null || allType.isEmpty()) {
            return;
        }
        ArrayList<IFile> toBeDeleted = new ArrayList<IFile>();
        for (String refType : allType) {
            String oppRef = factory.getOppositeReferenceType(refType);
            if (!factory.isExplicit(refType)) continue;
            Collection refs = registry.getReferences(file, refType);
            for (IProxyNode target : refs) {
                IFile targetfile = (IFile)target.getUnderlyingResource();
                if (!factory.isExplicit(oppRef)) {
                    registry.removeReference(targetfile, file);
                }
                toBeDeleted.add(targetfile);
            }
        }
        for (IFile targetFile : toBeDeleted) {
            registry.removeReference(file, targetFile);
        }
        toBeDeleted.clear();
    }

    public IProxyNode findProxyByID(IProxyNode proxy, String uid) {
        return this.fileProxyNodeCache.findProxyByID(proxy, uid);
    }

    public IProxyNode uncacheProxy(IFile file) {
        IProxyNode removedProxy = this.fileProxyNodeCache.remove(file);
        this.parents.remove(removedProxy);
        this.parentsToCache.remove(removedProxy);
        return removedProxy;
    }

    public IProxyNode getCorrespondingProxy(Object object) {
        return this.fileProxyNodeCache.getCorrespondingProxy(object);
    }

    public IProxyNode getCorrespondingProxy(String fileName, String identifier) {
        return this.getCorrespondingProxy(new Proxy(fileName, identifier));
    }

    public Object getParent(IProxyNode proxy) {
        if (proxy != null) {
            Object parent = proxy.getParent();
            if (parent != null && parent instanceof IUnboundedParent) {
                return this.parents.get(proxy);
            }
            return parent;
        }
        return null;
    }

    public void dispose() {
        if (this.fileProxyNodeCache != null) {
            this.fileProxyNodeCache.dispose();
            this.fileProxyNodeCache = null;
        }
    }

    public static interface IUnboundedParent {
    }
}

