/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyMetadataPersister;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IFileProxyPersister;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class FileProxyMarkerPersister
implements IFileProxyPersister {
    private FileProxyMetadataPersister fileProxyMetadataPersister = new FileProxyMetadataPersister();
    private static MarkerJob markerJob = null;
    private static final String MARKER_PROXYSTATE = "org.eclipse.hyades.test.ui.proxyStateMarker";

    public IProxyNode loadProxy(IFile file) {
        try {
            MarkerRecord markerRecord;
            if (markerJob != null && (markerRecord = markerJob.getScheduledMarker(file)) != null && markerRecord.getProxyState() != null) {
                return FileProxyMetadataPersister.deserializeProxyNode(file, markerRecord.getProxyFactoryId(), (IMemento)XMLMemento.createReadRoot((Reader)new StringReader(markerRecord.getProxyState())));
            }
            IMarker[] markers = file.findMarkers(MARKER_PROXYSTATE, false, 0);
            if (markers.length > 0 && file.getModificationStamp() == Long.parseLong(markers[0].getAttribute("lastSaveStamp", "0"))) {
                String proxyFactoryId = markers[0].getAttribute("factoryID", null);
                if (FileProxyNodeCache.NULL_PROXY.getFactoryID().equals(proxyFactoryId)) {
                    return FileProxyNodeCache.NULL_PROXY;
                }
                String proxyState = markers[0].getAttribute("proxyState", null);
                if (proxyState != null) {
                    return FileProxyMetadataPersister.deserializeProxyNode(file, proxyFactoryId, (IMemento)XMLMemento.createReadRoot((Reader)new StringReader(proxyState)));
                }
                return this.fileProxyMetadataPersister.loadProxy(file);
            }
        }
        catch (Exception e) {
            UiPlugin.logError(e);
            try {
                file.deleteMarkers(MARKER_PROXYSTATE, false, 0);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void saveProxy(IFile file, IPersistableProxyNode proxyNode) throws Exception {
        XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)"proxyStateMemento");
        proxyNode.saveState((IMemento)xmlMemento);
        StringWriter proxyStateWriter = new StringWriter();
        xmlMemento.save((Writer)proxyStateWriter);
        String proxyState = proxyStateWriter.toString();
        boolean isValidProxySize = true;
        try {
            isValidProxySize = proxyState.getBytes("UTF-8").length <= 65535;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            isValidProxySize = false;
        }
        if (markerJob != null) {
            if (markerJob.getState() != 4 && markerJob.cancel()) {
                if (markerJob.scheduleMarker(file, proxyNode.getFactoryID(), isValidProxySize ? proxyState : null)) {
                    markerJob.schedule();
                } else {
                    markerJob = null;
                }
            } else {
                markerJob = null;
            }
        }
        if (markerJob == null) {
            markerJob = new MarkerJob();
            markerJob.scheduleMarker(file, proxyNode.getFactoryID(), isValidProxySize ? proxyState : null);
            markerJob.schedule();
        }
        if (!isValidProxySize) {
            this.fileProxyMetadataPersister.saveProxy(file, proxyNode);
        }
    }

    private static class MarkerJob
    extends WorkspaceJob {
        private List<MarkerRecord> scheduledMarkers = new ArrayList<MarkerRecord>();
        private static final ILock LOCK = Job.getJobManager().newLock();

        public MarkerJob() {
            super("MarkerJob");
            this.setPriority(20);
            this.setSystem(true);
        }

        public MarkerRecord getScheduledMarker(IFile file) {
            try {
                LOCK.acquire();
                for (MarkerRecord markerRecord : this.scheduledMarkers) {
                    if (!markerRecord.getFile().equals((Object)file)) continue;
                    MarkerRecord markerRecord2 = markerRecord;
                    return markerRecord2;
                }
            }
            finally {
                LOCK.release();
            }
            return null;
        }

        public boolean scheduleMarker(IFile file, String proxyFactoryId, String proxyState) {
            if (this.getState() == 0) {
                MarkerRecord markerRecord = new MarkerRecord(file, proxyFactoryId, proxyState);
                IFile newRule = file;
                ISchedulingRule currentRule = this.getRule();
                if (currentRule instanceof MultiRule) {
                    ISchedulingRule[] currentChildRules = ((MultiRule)currentRule).getChildren();
                    ISchedulingRule[] newChildRules = new ISchedulingRule[currentChildRules.length + 1];
                    System.arraycopy(currentChildRules, 0, newChildRules, 0, currentChildRules.length);
                    newChildRules[currentChildRules.length] = file;
                    newRule = new MultiRule(newChildRules);
                } else if (currentRule != null) {
                    newRule = new MultiRule(new ISchedulingRule[]{currentRule, file});
                }
                try {
                    this.setRule((ISchedulingRule)newRule);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.scheduledMarkers.remove(markerRecord);
                }
                this.scheduledMarkers.add(markerRecord);
                return true;
            }
            return false;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                MultiStatus multiStatus;
                LOCK.acquire();
                monitor.beginTask("", this.scheduledMarkers.size());
                try {
                    MultiStatus multiStatus2 = new MultiStatus(UiPlugin.getID(), 0, "Marker job multi-status", null);
                    for (MarkerRecord markerRecord : this.scheduledMarkers) {
                        IStatus status;
                        if (markerRecord.getFile().isAccessible() && (status = markerRecord.serialize()).getSeverity() != 0) {
                            multiStatus2.add(status);
                        }
                        monitor.worked(1);
                    }
                    multiStatus = multiStatus2;
                    this.scheduledMarkers.clear();
                }
                catch (Throwable throwable) {
                    this.scheduledMarkers.clear();
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
                return multiStatus;
            }
            finally {
                LOCK.release();
            }
        }
    }

    private static class MarkerRecord {
        private IFile file = null;
        private String proxyFactoryId = null;
        private String proxyState = null;
        private long lastFileModificationStamp = -1L;

        public MarkerRecord(IFile file, String proxyFactoryId, String proxyState) {
            this.file = file;
            this.proxyFactoryId = proxyFactoryId;
            this.proxyState = proxyState;
            this.lastFileModificationStamp = file.getModificationStamp();
        }

        public IStatus serialize() {
            try {
                this.file.deleteMarkers(FileProxyMarkerPersister.MARKER_PROXYSTATE, false, 0);
                IMarker marker = this.file.createMarker(FileProxyMarkerPersister.MARKER_PROXYSTATE);
                marker.setAttribute("lastSaveStamp", (Object)String.valueOf(this.lastFileModificationStamp));
                marker.setAttribute("factoryID", (Object)this.proxyFactoryId);
                if (this.proxyState != null) {
                    marker.setAttribute("proxyState", (Object)this.proxyState);
                }
                return Status.OK_STATUS;
            }
            catch (Throwable e) {
                UiPlugin.logError(e);
                return new Status(4, UiPlugin.getID(), "Unable to create/update a marker for file '" + this.file.getName() + "'", e);
            }
        }

        public IFile getFile() {
            return this.file;
        }

        public String getProxyFactoryId() {
            return this.proxyFactoryId;
        }

        public String getProxyState() {
            return this.proxyState;
        }
    }
}

