/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IFileProxyPersister;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementFactoryManager;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

public class FileProxyMetadataPersister
implements IFileProxyPersister {
    private IPath storageArea = Platform.getStateLocation((Bundle)Platform.getBundle((String)UiPlugin.getID()));
    public static final String TAG_FACTORY_ID = "factoryID";
    public static final String TAG_PROXY_STATE = "proxyState";
    public static final String TAG_LAST_SAVE_STAMP = "lastSaveStamp";
    public static final String PROXY_STATE_MEMENTO_TYPE = "proxyStateMemento";

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IProxyNode loadProxy(IFile file) {
        Reader reader;
        block15: {
            String proxyFactoryId;
            XMLMemento memento;
            block16: {
                reader = null;
                File mementoFile = new File(this.storageArea.append(file.getFullPath()).toOSString());
                if (!mementoFile.canRead()) break block15;
                reader = new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(mementoFile))));
                memento = XMLMemento.createReadRoot((Reader)reader);
                String lastSaveTimeStamp = memento.getString(TAG_LAST_SAVE_STAMP);
                if (file.getModificationStamp() != (lastSaveTimeStamp != null ? Long.parseLong(lastSaveTimeStamp) : 0L)) break block15;
                proxyFactoryId = memento.getString(TAG_FACTORY_ID);
                if (!FileProxyNodeCache.NULL_PROXY.getFactoryID().equals(proxyFactoryId)) break block16;
                FileProxyNodeCache.NullProxy nullProxy = FileProxyNodeCache.NULL_PROXY;
                if (reader == null) return nullProxy;
                try {
                    reader.close();
                    return nullProxy;
                }
                catch (IOException iOException) {}
                return nullProxy;
            }
            IMemento proxyState = memento.getChild(TAG_PROXY_STATE);
            if (proxyState == null) break block15;
            IProxyNode iProxyNode = FileProxyMetadataPersister.deserializeProxyNode(file, proxyFactoryId, proxyState);
            if (reader == null) return iProxyNode;
            try {
                reader.close();
                return iProxyNode;
            }
            catch (IOException iOException) {}
            return iProxyNode;
            catch (Exception e) {
                try {
                    UiPlugin.logError(e);
                    if (reader == null) return null;
                }
                catch (Throwable throwable) {
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    reader.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        if (reader == null) return null;
        try {
            reader.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public void saveProxy(IFile file, IPersistableProxyNode proxyNode) throws Exception {
        Writer writer = null;
        try {
            File mementoFile = new File(this.storageArea.append(file.getFullPath()).toOSString());
            mementoFile.getParentFile().mkdirs();
            writer = new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(mementoFile))));
            XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)PROXY_STATE_MEMENTO_TYPE);
            xmlMemento.putString(TAG_LAST_SAVE_STAMP, String.valueOf(file.getModificationStamp()));
            xmlMemento.putString(TAG_FACTORY_ID, proxyNode.getFactoryID());
            proxyNode.saveState(xmlMemento.createChild(TAG_PROXY_STATE));
            xmlMemento.save(writer);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static IProxyNode deserializeProxyNode(IFile file, String proxyFactoryId, IMemento memento) {
        try {
            memento.putString("uriRoot", file.getFullPath().toString());
            IFileProxyFactory fileProxyFactory = TestNavigator.getFileFactoryManager().getFactory(proxyFactoryId);
            if (fileProxyFactory != null) {
                if (fileProxyFactory instanceof IPersistableFileProxyFactory) {
                    IProxyNode proxyNode = ((IPersistableFileProxyFactory)fileProxyFactory).recreate(memento, file, FileProxyNodeCache.UNBOUNDED_PARENT);
                    Assert.isLegal((boolean)file.equals(proxyNode.getAdapter(IFile.class)), (String)("Invalid proxy '" + proxyNode.getClass().getName() + "' returned by factory '" + fileProxyFactory.getClass().getName() + "' for file '" + file.getFullPath().toString() + "'."));
                    return proxyNode;
                }
                UiPlugin.logError("The factory id '" + proxyFactoryId + "' is not an instance of IPersistableFileProxyFactory");
            } else {
                ITypedElementProxyFactory typedElementProxyFactory = TypedElementFactoryManager.getInstance().getFactoryFromID(proxyFactoryId);
                if (typedElementProxyFactory != null) {
                    if (typedElementProxyFactory instanceof IPersistableTypedElementProxyFactory) {
                        return ((IPersistableTypedElementProxyFactory)typedElementProxyFactory).recreate(memento, FileProxyNodeCache.UNBOUNDED_PARENT);
                    }
                    UiPlugin.logError("The factory id '" + proxyFactoryId + "' is not an instance of IPersistableTypedElementProxyFactory");
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

