/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ITestAssetGroupProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestAssetGroupProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;

public class TestAssetGroupProxyManager
implements IResourceChangeListener {
    private Map extensions = new HashMap();
    private Map cache = new HashMap();
    private IProxyNodeListener refresher;
    private static final ILock LOCK = Job.getJobManager().newLock();

    public TestAssetGroupProxyManager(ITypeProviderContext context) {
        this.refresher = context.getProxyNodeListener();
        this.registerGroupProxies();
        FileProxyNodeCache.getInstance().addResourceListener(this);
    }

    private void registerGroupProxies() {
        IExtensionPoint extensionPointt = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorTestAssetGroupProxy");
        if (extensionPointt != null) {
            IConfigurationElement[] configurationElements = extensionPointt.getConfigurationElements();
            int counter = 0;
            while (counter < configurationElements.length) {
                String extension;
                IConfigurationElement configurationElement = configurationElements[counter];
                if ("testAsset".equals(configurationElement.getName()) && (extension = configurationElement.getAttribute("extension")) != null && extension.trim().length() > 0) {
                    String icon;
                    boolean isFlat = true;
                    String flat = configurationElement.getAttribute("flat");
                    if (flat != null) {
                        isFlat = Boolean.parseBoolean(flat);
                    }
                    if ((icon = configurationElement.getAttribute("icon")) != null) {
                        UiPlugin.getDefault().putImage(Platform.getBundle((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier()), icon);
                    }
                    boolean isCaseSensitive = true;
                    String caseSensitive = configurationElement.getAttribute("caseSensitive");
                    if (caseSensitive != null) {
                        isCaseSensitive = Boolean.parseBoolean(caseSensitive);
                    }
                    if (!isCaseSensitive) {
                        extension = extension.toLowerCase();
                    }
                    this.addExtension(extension, new TestAssetInfo(configurationElement.getAttribute("name"), isFlat, icon, isCaseSensitive));
                }
                ++counter;
            }
        }
    }

    private void addExtension(String extension, TestAssetInfo info) {
        if (!this.extensions.containsKey(extension)) {
            this.extensions.put(extension, info);
        } else {
            UiPlugin.logInfo("extension: " + extension + " already registered");
        }
    }

    public Collection getExtensions() {
        return this.extensions.keySet();
    }

    public ITestAssetGroupProxyNode getTestAssetGroup(IProject project, String extension) {
        ITestAssetGroupProxyNode group = this.cacheGet(project, extension);
        if (group == null) {
            TestAssetInfo info = (TestAssetInfo)this.extensions.get(extension);
            if (info == null && (info = (TestAssetInfo)this.extensions.get(extension.toLowerCase())) != null) {
                if (info.isCaseSensitive()) {
                    info = null;
                } else {
                    extension = extension.toLowerCase();
                }
            }
            if (this.extensions.containsKey(extension)) {
                try {
                    LOCK.acquire();
                    group = this.cacheGet(project, extension);
                    if (group == null) {
                        group = new TestAssetGroupProxyNode(project, extension, info.getName(), info.getImageKey(), info.isFlat, project, info.isCaseSensitive());
                        this.cachePut(project, extension, group);
                    }
                }
                finally {
                    LOCK.release();
                }
            }
        }
        if (group != null && group.getChildren().length > 0) {
            return group;
        }
        return null;
    }

    private void cachePut(IProject project, String extension, ITestAssetGroupProxyNode testAsset) {
        HashMap<String, ITestAssetGroupProxyNode> map = (HashMap<String, ITestAssetGroupProxyNode>)this.cache.get(project);
        if (map == null) {
            map = new HashMap<String, ITestAssetGroupProxyNode>();
            this.cache.put(project, map);
        }
        map.put(extension, testAsset);
    }

    private ITestAssetGroupProxyNode cacheGet(IProject project, String extension) {
        ITestAssetGroupProxyNode group;
        Map map = (Map)this.cache.get(project);
        if (map != null && (group = (ITestAssetGroupProxyNode)map.get(extension)) != null) {
            return group;
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        Object lowestChanged = null;
        IResourceDelta resDelta = event.getDelta();
        IResourceDelta[] affectedProjects = resDelta.getAffectedChildren();
        affectedProjects = this.filter(affectedProjects);
        int i = 0;
        while (i < affectedProjects.length) {
            IResourceDelta delta = affectedProjects[i];
            IProject project = (IProject)delta.getResource();
            Map groups = (Map)this.cache.get(project);
            if (groups != null) {
                for (String ext : this.extensions.keySet()) {
                    TestAssetGroupProxyNode proxy = (TestAssetGroupProxyNode)groups.get(ext);
                    if (proxy == null) continue;
                    IProxyNode lowestProxy = proxy.resourceChanged(delta);
                    if (proxy.getChildren().length == 0) {
                        lowestChanged = project;
                        lowestProxy = null;
                    }
                    if (lowestProxy == null) continue;
                    lowestChanged = lowestChanged == null ? lowestProxy : project;
                }
            }
            ++i;
        }
        if (lowestChanged != null) {
            this.refresher.nodeChanged(lowestChanged);
        }
    }

    public void dispose() {
        FileProxyNodeCache.getInstance().removeResourceListener(this);
    }

    private IResourceDelta[] filter(IResourceDelta[] deltas) {
        if (deltas == null || deltas.length == 0) {
            return deltas;
        }
        final HashSet resourceDeltas = new HashSet(deltas.length);
        int i = 0;
        while (i < deltas.length) {
            try {
                final IResourceDelta projectDelta = deltas[i];
                projectDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        IResource res = delta.getResource();
                        if (res.getType() != 1) {
                            return true;
                        }
                        switch (delta.getKind()) {
                            case 4: {
                                int flags = delta.getFlags();
                                if ((flags & 0x20000) != 0) {
                                    IMarkerDelta[] markdelta = delta.getMarkerDeltas();
                                    int j = 0;
                                    while (j < markdelta.length) {
                                        if (markdelta[j].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                                            resourceDeltas.add(projectDelta);
                                            return false;
                                        }
                                        ++j;
                                    }
                                    break;
                                }
                                resourceDeltas.add(projectDelta);
                                break;
                            }
                            case 1: 
                            case 2: {
                                resourceDeltas.add(projectDelta);
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
            }
            ++i;
        }
        return resourceDeltas.toArray(new IResourceDelta[resourceDeltas.size()]);
    }

    static class TestAssetInfo {
        private String name;
        private boolean isFlat;
        private String imageKey;
        private boolean caseSensitive;

        public TestAssetInfo(String name, boolean isFlat, String imageKey, boolean caseSensitive) {
            this.name = name;
            this.isFlat = isFlat;
            this.imageKey = imageKey;
            this.caseSensitive = caseSensitive;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public String getImageKey() {
            return this.imageKey;
        }

        public boolean isFlat() {
            return this.isFlat;
        }

        public String getName() {
            return this.name;
        }
    }
}

