/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.LogicalTestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ITestAssetGroupProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode;
import org.eclipse.swt.graphics.Image;

public class TestAssetGroupProxyNode
extends TestFolderProxyNode
implements ITestAssetGroupProxyNode {
    private String extension;
    private String name;
    private String imageKey;

    public TestAssetGroupProxyNode(IProject project, String extension, String name, String imageKey, boolean flat, Object parent, boolean caseSensitive) {
        super((IContainer)project, new TestAssetGroupValidator(extension, caseSensitive), LogicalTestNavigatorContentProvider.getSharedFileProxyManager(), flat, parent);
        this.extension = extension;
        this.name = name;
        this.imageKey = imageKey;
    }

    public boolean isApplicableFor() {
        return false;
    }

    public Image getImage() {
        if (this.imageKey != null && this.imageKey.length() > 0) {
            return UiPlugin.getInstance().getImage(this.imageKey);
        }
        return super.getImage();
    }

    public String getText() {
        if (this.name != null && this.name.length() > 0) {
            return this.name;
        }
        return "";
    }

    public String getExtension() {
        return this.extension;
    }

    static class TestAssetGroupValidator
    implements ITestFolderContentValidator {
        private String extension;
        private boolean caseSensitive;

        public TestAssetGroupValidator(String extension, boolean caseSensitive) {
            this.extension = extension;
            this.caseSensitive = caseSensitive;
        }

        public boolean isFileOk(IFile file) {
            String ext = file.getFileExtension();
            if (file != null && ext != null) {
                if (this.caseSensitive) {
                    return ext.equals(this.extension);
                }
                return ext.toLowerCase().equals(this.extension);
            }
            return false;
        }

        public boolean isProxyOk(IProxyNode node) {
            return true;
        }
    }
}

