/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ProxiesRequest;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestNavigatorResourceRefreshJob;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class FileProxiesRequest
extends ProxiesRequest
implements ITestNavigatorResourceRefreshJob {
    private IFileProxyManager fileProxyManager;
    private IContainer parent;

    public FileProxiesRequest(Collection files, IFileProxyManager fileProxyManager, IContainer parent, TestNavigator testNavigator) {
        super(NLS.bind((String)TestNavigatorMessages.PM_EXPLORING_FOLDER, (Object)parent.getFullPath().toString()), files, testNavigator);
        this.fileProxyManager = fileProxyManager;
        this.parent = parent;
    }

    public IContainer getParent() {
        return this.parent;
    }

    protected IProxyNode computeProxy(Object key) {
        return this.fileProxyManager.getProxy((IFile)key, this.parent);
    }

    protected IProxyNode getPlaceHolder(Object key) {
        return new TemporaryProxyNode((IFile)key, this.parent);
    }

    protected String getTaskName() {
        return NLS.bind((String)TestNavigatorMessages.PM_EXPLORING_FOLDER, (Object)this.parent.getFullPath().toString());
    }

    protected String getSubTaskName(Object key) {
        return NLS.bind((String)TestNavigatorMessages.PM_INDEXING_FILE, (Object)((IFile)key).getName());
    }

    private static class TemporaryProxyNode
    implements IExtendedProxyNode {
        private IFile file;
        private Object parent;

        public TemporaryProxyNode(IFile file, Object parent) {
            this.file = file;
            this.parent = parent;
        }

        public IProxyNode[] getChildren() {
            return new IProxyNode[0];
        }

        public Image getImage() {
            return null;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getText() {
            return this.file.getName();
        }

        public Object getAdapter(Class adapter) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public String getIdentifier() {
            return "#";
        }

        public IResource getUnderlyingResource() {
            return this.file;
        }

        public IResource getCorrespondingResource() {
            return this.file;
        }
    }
}

