/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ISynchronizedAccess;

public class JobSynchronizedAccess
implements ISynchronizedAccess {
    private Collection rules = Collections.synchronizedList(new ArrayList(4));

    public boolean acquireLock(Object resource) {
        ResourceRule rule = new ResourceRule(this, resource);
        Platform.getJobManager().beginRule((ISchedulingRule)rule, (IProgressMonitor)new NullProgressMonitor());
        this.rules.add(rule);
        return true;
    }

    private ResourceRule removeRule(Object resource) {
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            ResourceRule rule = (ResourceRule)it.next();
            if (!rule.resource.equals(resource)) continue;
            it.remove();
            return rule;
        }
        return null;
    }

    public void releaseLock(Object resource) {
        ResourceRule rule = this.removeRule(resource);
        if (rule != null) {
            Platform.getJobManager().endRule((ISchedulingRule)rule);
        }
    }

    private static class ResourceRule
    implements ISchedulingRule {
        private JobSynchronizedAccess owner;
        private Object resource;

        public ResourceRule(JobSynchronizedAccess owner, Object resource) {
            this.owner = owner;
            this.resource = resource;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule == this) {
                return true;
            }
            return ResourcesPlugin.getWorkspace().getRoot().contains(rule);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof ResourceRule) {
                ResourceRule oRule = (ResourceRule)rule;
                return this.owner == oRule.owner && this.resource.equals(oRule.resource);
            }
            return false;
        }
    }
}

