/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.internal.execution.local.control.NotImplementedException;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.swt.graphics.Image;

public class CompositeReferencerProxyNode
implements IReferencerProxyNode {
    private IProxyNode proxy;
    private Map types;

    public CompositeReferencerProxyNode(IProxyNode proxy) {
        this.proxy = proxy;
        this.types = new HashMap();
        this.getDeepReferences(proxy);
    }

    public Set getReferenceTypes() {
        return this.types.keySet();
    }

    public Collection getReferences(String refType) {
        return (Collection)this.types.get(refType);
    }

    private void getDeepReferences(IProxyNode p) {
        IReferencerProxyNode referencer;
        Set allTypes;
        if (p instanceof IReferencerProxyNode && (allTypes = (referencer = (IReferencerProxyNode)p).getReferenceTypes()) != null) {
            for (String type : allTypes) {
                this.types.put(type, referencer.getReferences(type));
            }
        }
        IProxyNode[] children = p.getChildren();
        int i = 0;
        while (i < children.length) {
            this.getDeepReferences(children[i]);
            ++i;
        }
    }

    public void removeReference(IProxyNode reference) {
        throw new NotImplementedException();
    }

    public String getIdentifier() {
        return this.proxy.getIdentifier();
    }

    public IResource getUnderlyingResource() {
        return this.proxy.getUnderlyingResource();
    }

    public IProxyNode[] getChildren() {
        return this.proxy.getChildren();
    }

    public Image getImage() {
        return this.proxy.getImage();
    }

    public Object getParent() {
        return this.proxy.getParent();
    }

    public String getText() {
        return this.proxy.getText();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProxyNode.class) {
            return this.proxy;
        }
        return this.proxy.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompositeReferencerProxyNode) {
            CompositeReferencerProxyNode c = (CompositeReferencerProxyNode)obj;
            return this.proxy.equals(c.proxy);
        }
        return false;
    }

    public int hashCode() {
        return this.proxy.hashCode();
    }

    public IProxyNode getProxy() {
        return this.proxy;
    }
}

