/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;

public class ReferenceTypeRegistry {
    private static ReferenceTypeRegistry instance;
    private Map types = new HashMap();

    private ReferenceTypeRegistry() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorReferenceTypes");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element = members[i];
                if ("type".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    String name = element.getAttribute("name");
                    boolean owns = Boolean.valueOf(element.getAttribute("owns"));
                    boolean isExplicit = Boolean.valueOf(element.getAttribute("isExplicit"));
                    String oppositeId = element.getAttribute("oppositeReferenceTypeId");
                    this.types.put(id, new ReferenceType(name, owns, isExplicit, oppositeId));
                }
                ++i;
            }
        }
    }

    public static ReferenceTypeRegistry getInstance() {
        if (instance == null) {
            instance = new ReferenceTypeRegistry();
        }
        return instance;
    }

    public boolean owns(String refTypeId) {
        ReferenceType type = (ReferenceType)this.types.get(refTypeId);
        if (type != null) {
            return type.owns();
        }
        UiPlugin.logWarning("Unable to find reference type: " + refTypeId + " default setting is applied.");
        return false;
    }

    public boolean isExplicit(String refTypeId) {
        if (refTypeId != null) {
            ReferenceType type = (ReferenceType)this.types.get(refTypeId);
            if (type != null) {
                return type.isExplicit();
            }
            UiPlugin.logWarning("Unable to find reference type: " + refTypeId + " default setting is applied.");
        }
        return false;
    }

    public String getName(String refTypeId) {
        ReferenceType type = (ReferenceType)this.types.get(refTypeId);
        if (type != null) {
            return type.getName();
        }
        UiPlugin.logWarning("Unable to find reference type: " + refTypeId + " default setting is applied.");
        return "Unknown reference";
    }

    public String getOppositeReferenceType(String refTypeId) {
        ReferenceType type = (ReferenceType)this.types.get(refTypeId);
        if (type != null) {
            return type.getOppositeId();
        }
        UiPlugin.logWarning("Unable to find reference type: " + refTypeId + " default setting is applied.");
        return "Unknown reference";
    }

    static class ReferenceType {
        private String name;
        private boolean owns;
        private boolean isExplicit;
        private String oppositeId;

        public ReferenceType(String name, boolean owns, boolean isExplicit, String oppositeId) {
            this.name = name;
            this.owns = owns;
            this.isExplicit = isExplicit;
            this.oppositeId = oppositeId;
        }

        public boolean owns() {
            return this.owns;
        }

        public boolean isExplicit() {
            return this.isExplicit;
        }

        public String getOppositeId() {
            return this.oppositeId;
        }

        public String getName() {
            return this.name;
        }
    }
}

