/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CompositeChangeWithRoot
extends CompositeChange {
    private Change root;
    private String name;

    public CompositeChangeWithRoot(Change root) {
        super("");
        Assert.isNotNull((Object)root);
        this.root = root;
    }

    public CompositeChangeWithRoot(Change root, String name) {
        super(name);
        this.root = root;
        if (root == null) {
            Assert.isLegal((name != null && name.length() > 0 ? 1 : 0) != 0, (String)"Empty name with null root");
            this.name = name;
        }
    }

    public String getName() {
        return this.root != null ? this.root.getName() : this.name;
    }

    public Change freeze() {
        if (this.getChildren().length == 0) {
            return this.root;
        }
        if (this.root instanceof CompositeChange) {
            this.merge((CompositeChange)this.root);
        } else {
            this.add(this.root);
        }
        return this;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.getChildren().length + 1);
        try {
            RefactoringStatus status = super.isValid((IProgressMonitor)new SubProgressMonitor(pm, this.getChildren().length));
            if (this.root != null) {
                status.merge(this.root.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }
}

