/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.ReorgContainerCompositeChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.osgi.util.NLS;

public class DeleteContainerCompositeChange
extends ReorgContainerCompositeChange {
    private DeleteContainerChange delChange;
    private boolean physicalDelete = true;
    private List associationList;

    public DeleteContainerCompositeChange(IContainer container, boolean physicalDelete, String baseDisplayName, List associationList) {
        super(NLS.bind((String)baseDisplayName, (Object)container.getFullPath().toString()), container);
        this.delChange = new DeleteContainerChange(container, physicalDelete, associationList);
        this.associationList = associationList;
        this.physicalDelete = physicalDelete;
    }

    public Change getDeleteContainerChange() {
        return this.delChange;
    }

    public Change getRootChange() {
        return this.delChange;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        boolean needToPerform = true;
        if (this.associationList != null) {
            for (Change proxChange : this.associationList) {
                needToPerform &= proxChange.isEnabled();
            }
        }
        Change[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            needToPerform &= children[i].isEnabled();
            ++i;
        }
        Change undo = null;
        if (needToPerform) {
            if (this.getContainer() instanceof IProject && this.physicalDelete) {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IWorkspaceDescription desc = ws.getDescription();
                boolean autobuilding = desc.isAutoBuilding();
                if (autobuilding) {
                    desc.setAutoBuilding(false);
                    ws.setDescription(desc);
                }
                undo = this.getRootChange().perform(pm);
                if (autobuilding) {
                    desc.setAutoBuilding(true);
                    ws.setDescription(desc);
                }
            } else {
                CompositeChange composite = new CompositeChange("undo");
                Change child = this.performChilds(pm);
                composite.add(this.getRootChange().perform(pm));
                composite.add(child);
                undo = composite;
            }
        } else {
            undo = this.performChilds(pm);
        }
        return undo;
    }
}

