/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PhysicalDeleteChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.TrashBox;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteFileChange
extends PhysicalDeleteChange {
    private IFile file;
    private String name;

    public DeleteFileChange(IFile file) {
        Assert.isNotNull((Object)file, (String)"file");
        this.file = file;
        this.updateAssociationMapping((IResource)file);
    }

    public DeleteFileChange(IFile file, String name) {
        this(file);
        this.name = name;
        this.updateAssociationMapping((IResource)file);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.file.exists()) {
            status.addError(RefactoringMessages.NO_FILE);
        }
        if (this.file.isReadOnly()) {
            status.addWarning(RefactoringMessages.READ_ONLY_FILE);
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringMessages.DELETING_FILE, 1);
            Change undo = null;
            if (this.file.exists()) {
                this.file.refreshLocal(0, null);
                if (this.file.isAccessible() && !this.file.isReadOnly()) {
                    try {
                        TrashBox.instance().trashResource((IResource)this.file);
                        undo = TrashBox.instance().createUntrashChange((IResource)this.file);
                    }
                    catch (Exception e) {
                        UiPlugin.logError("error while putting file into trashbox : " + this.file.getName());
                        UiPlugin.logError(e);
                    }
                    this.file.delete(true, true, pm);
                }
            }
            Change change = undo;
            return change;
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return NLS.bind((String)RefactoringMessages.DELETE_FILE, (Object)this.file.getFullPath().toString());
    }

    public Object getModifiedElement() {
        return this.file;
    }

    public Object[] getAffectedObjects() {
        Object[] res = new Object[]{this.file};
        return res;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }
}

