/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.CompositeReferencerProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CompositeListenerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CustomRefactoringManager;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteContainerCompositeChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteFileChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteLogicalProjectChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RefactoringContext;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RefactoringTransactionRootChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.TrashBox;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeDeleter;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeUpdater;
import org.eclipse.hyades.test.ui.navigator.refactoring.DeleteRefactoringEvent;
import org.eclipse.hyades.test.ui.navigator.refactoring.UpdateRefactoringEvent;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteRefactoring
extends Refactoring {
    private List containers;
    private List proxies;
    private List targetProxies;
    private List seenElements;
    private Change change;
    private RefactoringContext context;
    private boolean deepRemove;
    private boolean update;
    private Collection nodesToUpdateLater;
    private boolean projectRemove;
    private boolean projectClosed;
    private boolean physicalDelete;
    private HashMap associationMap;

    public HashMap getAssociationMap() {
        return this.associationMap;
    }

    public boolean isProjectRemove() {
        return this.projectRemove;
    }

    public boolean isProjectClosed() {
        return this.projectClosed;
    }

    public List getContainers() {
        return this.containers;
    }

    public List getProxies() {
        return this.proxies;
    }

    public DeleteRefactoring(List containers, List proxies) {
        this.containers = containers;
        this.proxies = proxies;
        this.context = new RefactoringContext();
        this.deepRemove = false;
        this.projectRemove = false;
        this.projectClosed = false;
        Iterator it = containers.iterator();
        while (it.hasNext() && !this.projectRemove) {
            IContainer cont = (IContainer)it.next();
            if (!(cont instanceof IProject)) continue;
            this.projectRemove = true;
            if (cont.isAccessible()) continue;
            this.projectClosed = true;
        }
        this.physicalDelete = false;
        this.initializeChangeComputation();
    }

    private void initializeChangeComputation() {
        this.change = null;
        this.targetProxies = new ArrayList();
        this.seenElements = new LinkedList();
        this.nodesToUpdateLater = new HashSet();
        this.associationMap = new HashMap();
        DeleteFileChange.setDeletetefactoring(this);
        DeleteContainerChange.setDeletetefactoring(this);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 3);
        this.initializeChangeComputation();
        try {
            try {
                TestUIUtilities.createProxyNodes((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (OperationCanceledException operationCanceledException) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.ReorgRefactoring_CANCELED_OPERATION_MSG);
                pm.done();
                return refactoringStatus;
            }
            this.change = this.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
            RefactoringStatus valid = this.change.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (valid.hasError()) {
                this.change = null;
            }
            RefactoringStatus refactoringStatus = valid;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            if (this.containers != null) {
                boolean oneProject = false;
                boolean oneNotProject = this.proxies != null && !this.proxies.isEmpty();
                Iterator it = this.containers.iterator();
                while (!(!it.hasNext() || oneProject && oneNotProject)) {
                    IContainer cont = (IContainer)it.next();
                    if (cont instanceof IProject) {
                        oneProject = true;
                        continue;
                    }
                    oneNotProject = true;
                }
                if (oneProject && oneNotProject) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.DeleteResources_delete_error_mixed_types);
                    return refactoringStatus;
                }
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.change != null) {
            return this.change;
        }
        pm.beginTask("", this.containers.size() + this.proxies.size() + 1);
        try {
            this.searchAllResourceToDelete(this.targetProxies);
            RefactoringTransactionRootChange c = new RefactoringTransactionRootChange(this.context);
            TrashBox trash = null;
            try {
                trash = TrashBox.instance();
            }
            catch (Exception exception) {}
            c.add(trash.createRefreshOnUndoChange());
            CustomRefactoringManager.addAllStartingChange(c, 4);
            LinkedList<CompositeReferencerProxyNode> proxyReferencers = new LinkedList<CompositeReferencerProxyNode>();
            Iterator it = this.targetProxies.iterator();
            while (it.hasNext()) {
                proxyReferencers.add(new CompositeReferencerProxyNode((IProxyNode)it.next()));
            }
            for (CompositeReferencerProxyNode ref : proxyReferencers) {
                Change refChange;
                if (!this.seenElements.contains(ref) && (refChange = this.createDeleteReferencerChange(ref)) != null) {
                    c.add(refChange);
                }
                if (!this.proxies.contains(ref.getProxy())) continue;
                pm.worked(1);
            }
            for (IContainer elem : this.containers) {
                Change containerChange = this.createDeleteContainerChange(elem);
                if (containerChange != null) {
                    c.add(containerChange);
                }
                if (!this.containers.contains(elem)) continue;
                pm.worked(1);
            }
            this.processNodesToUpdateLater();
            CustomRefactoringManager.addAllEndingChange(c, 4);
            c.markAsSynthetic();
            c.add(trash.createCleanTrashChange());
            RefactoringTransactionRootChange refactoringTransactionRootChange = c;
            return refactoringTransactionRootChange;
        }
        finally {
            pm.done();
        }
    }

    private void searchAllResourceToDelete(List proxyToDelete) {
        for (Object elem : this.proxies) {
            if (proxyToDelete.contains(elem)) continue;
            proxyToDelete.add(elem);
        }
        Iterator it = this.containers.iterator();
        while (it.hasNext()) {
            this.recursiveSearchAllResourceToDelete((IResource)((IContainer)it.next()), proxyToDelete);
        }
    }

    private void recursiveSearchAllResourceToDelete(IResource resource, List proxyToDelete) {
        if (resource == null) {
            return;
        }
        if (!resource.exists() || !resource.isAccessible()) {
            return;
        }
        if (resource instanceof IContainer) {
            IResource[] childs;
            try {
                childs = ((IContainer)resource).members();
            }
            catch (CoreException coreException) {
                return;
            }
            int i = 0;
            while (i < childs.length) {
                this.recursiveSearchAllResourceToDelete(childs[i], proxyToDelete);
                ++i;
            }
            return;
        }
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy(file);
            if (proxy != null && !proxyToDelete.contains(proxy)) {
                proxyToDelete.add(proxy);
            }
        }
    }

    private static void insertFirst(CompositeChange composite, Change c) {
        composite.add(c);
        Change[] children = composite.getChildren();
        int i = 0;
        while (i < children.length - 1) {
            composite.remove(children[i]);
            composite.add(children[i]);
            ++i;
        }
    }

    private void processNodesToUpdateLater() {
        for (NodeToUpdateLater element : this.nodesToUpdateLater) {
            Change updateTypeChange = this.createUpdateReferenceTypeChange(element.getRefType(), element.getNode());
            if (updateTypeChange == null) continue;
            updateTypeChange.setEnabled(this.update);
            DeleteRefactoring.insertFirst(element.getComposite(), updateTypeChange);
        }
    }

    private Change createDeleteReferencerChange(CompositeReferencerProxyNode node) {
        IProxyNodeDeleter deleter = (IProxyNodeDeleter)node.getAdapter(IProxyNodeDeleter.class);
        if (deleter != null) {
            CompositeChange composite = new CompositeChange(NLS.bind((String)RefactoringMessages.DELETE_PROXY, (Object)node.getText()));
            this.seenElements.add(node);
            for (String refType : node.getReferenceTypes()) {
                Change referenceTypeChange;
                String oppType = ReferenceTypeRegistry.getInstance().getOppositeReferenceType(refType);
                if (ReferenceTypeRegistry.getInstance().owns(refType) && (referenceTypeChange = this.createDeleteReferenceTypeChange(refType, node)) != null) {
                    referenceTypeChange.setEnabled(this.deepRemove);
                    composite.add(referenceTypeChange);
                    continue;
                }
                if (!ReferenceTypeRegistry.getInstance().isExplicit(oppType)) continue;
                this.nodesToUpdateLater.add(new NodeToUpdateLater(composite, refType, node));
            }
            DeleteRefactoringEvent event = new DeleteRefactoringEvent(node);
            CompositeListenerChange compositeListener = new CompositeListenerChange(event);
            Change deleteChange = deleter.createDeleteChange(this.context);
            deleteChange.setEnabled(this.physicalDelete);
            compositeListener.add(deleteChange);
            composite.add((Change)compositeListener);
            return composite;
        }
        return null;
    }

    private Change createUpdateReferenceTypeChange(String refType, CompositeReferencerProxyNode node) {
        CompositeChange composite = new CompositeChange(NLS.bind((String)RefactoringMessages.UPDATE_PROXY, (Object)ReferenceTypeRegistry.getInstance().getName(refType)));
        Collection references = node.getReferences(refType);
        for (IProxyNode proxy : references) {
            IProxyNodeUpdater updater;
            if (this.seenElements.contains(new CompositeReferencerProxyNode(proxy)) || (updater = (IProxyNodeUpdater)proxy.getAdapter(IProxyNodeUpdater.class)) == null) continue;
            UpdateRefactoringEvent event = new UpdateRefactoringEvent(proxy, node, refType, null);
            CompositeListenerChange compositeListener = new CompositeListenerChange(event);
            compositeListener.add(updater.createUpdateChange(this.context, node, refType, null));
            composite.add((Change)compositeListener);
        }
        return composite.getChildren().length > 0 ? composite : null;
    }

    private Change createDeleteReferenceTypeChange(String refType, CompositeReferencerProxyNode node) {
        CompositeChange composite = new CompositeChange(NLS.bind((String)RefactoringMessages.DELETE_PROXY, (Object)ReferenceTypeRegistry.getInstance().getName(refType)));
        Collection references = node.getReferences(refType);
        for (IProxyNode proxy : references) {
            if (proxy.getAdapter(IFile.class) == null || this.targetProxies.contains(proxy)) continue;
            if (proxy instanceof IReferencerProxyNode) {
                Change refChange;
                CompositeReferencerProxyNode referenced = new CompositeReferencerProxyNode((IReferencerProxyNode)proxy);
                if (this.seenElements.contains(referenced) || (refChange = this.createDeleteReferencerChange(referenced)) == null) continue;
                composite.add(refChange);
                continue;
            }
            if (this.seenElements.contains(proxy)) continue;
            DeleteRefactoringEvent event = new DeleteRefactoringEvent(proxy);
            CompositeListenerChange compositeListener = new CompositeListenerChange(event);
            compositeListener.add(new DeleteFileChange((IFile)proxy.getUnderlyingResource()));
            composite.add((Change)compositeListener);
        }
        return composite.getChildren().length > 0 ? composite : null;
    }

    private Change createDeleteContainerChange(IContainer container) {
        DeleteRefactoringEvent event = new DeleteRefactoringEvent((IResource)container);
        CompositeListenerChange composite = new CompositeListenerChange(event);
        String baseDisplayName = container instanceof IProject ? RefactoringMessages.DELETE_PROJECT : RefactoringMessages.DELETE_FOLDER;
        DeleteContainerCompositeChange contChange = new DeleteContainerCompositeChange(container, this.physicalDelete, baseDisplayName, (List)this.associationMap.get(container));
        if (container.isAccessible()) {
            IResource[] resources;
            try {
                resources = container.members();
            }
            catch (CoreException e) {
                UiPlugin.logWarning("Unable to get members of container: " + container.getFullPath().toOSString(), e);
                return null;
            }
            int i = 0;
            while (i < resources.length) {
                if (!resources[i].isDerived()) {
                    if (resources[i] instanceof IFile) {
                        IFile file = (IFile)resources[i];
                        IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy(file);
                        if (proxy == null) {
                            DeleteRefactoringEvent subevent = new DeleteRefactoringEvent((IResource)file);
                            CompositeListenerChange compositeListener = new CompositeListenerChange(subevent);
                            DeleteFileChange deleteChange = new DeleteFileChange(file);
                            deleteChange.setEnabled(this.physicalDelete);
                            compositeListener.add(deleteChange);
                            contChange.add((Change)compositeListener);
                        }
                    } else {
                        contChange.add(this.createDeleteContainerChange((IContainer)resources[i]));
                    }
                }
                ++i;
            }
        }
        if (container instanceof IProject) {
            contChange.add(new DeleteLogicalProjectChange((IProject)container));
        }
        if (contChange.getChildren().length > 0) {
            composite.add((Change)contChange);
        } else {
            composite.add(contChange.getDeleteContainerChange());
        }
        return composite;
    }

    public String getName() {
        return "";
    }

    public void setDeepRemove(boolean deepRemove) {
        this.deepRemove = deepRemove;
    }

    public boolean getDeepRemove() {
        return this.deepRemove;
    }

    public void setUpdate(boolean updateValue) {
        this.update = updateValue;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setPhysicalDelete(boolean physicalDelete) {
        this.physicalDelete = physicalDelete;
    }

    public boolean getPhysicalDelete() {
        return this.physicalDelete;
    }

    private class NodeToUpdateLater {
        private CompositeChange composite;
        private String refType;
        private CompositeReferencerProxyNode node;

        public NodeToUpdateLater(CompositeChange composite, String refType, CompositeReferencerProxyNode node) {
            this.composite = composite;
            this.refType = refType;
            this.node = node;
        }

        public CompositeChange getComposite() {
            return this.composite;
        }

        public CompositeReferencerProxyNode getNode() {
            return this.node;
        }

        public String getRefType() {
            return this.refType;
        }
    }
}

