/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DeleteRefactoringWizard
extends RefactoringWizard {
    private DeleteRefactoringInputPage page;

    public DeleteRefactoringWizard(Refactoring refactoring) {
        super(refactoring, 4);
    }

    protected void addUserInputPages() {
        this.page = new DeleteRefactoringInputPage(this.getRefactoring());
        this.addPage((IWizardPage)this.page);
    }

    private class DeleteRefactoringInputPage
    extends UserInputWizardPage {
        private DeleteRefactoring refactoring;
        private Button check;
        private Button delete;
        private Button update;

        public DeleteRefactoringInputPage(Refactoring ref) {
            super("");
            this.refactoring = (DeleteRefactoring)ref;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            result.setLayout((Layout)new GridLayout());
            this.addLabel(result);
            if (this.refactoring.isProjectRemove()) {
                this.addProjectCheckBox(result);
            } else {
                this.addDeleteRemoveCheckBox(result);
            }
            Dialog.applyDialogFont((Control)result);
        }

        private void addDeleteRemoveCheckBox(Composite parent) {
            this.refactoring.setPhysicalDelete(true);
            this.check = new Button(parent, 32);
            this.check.setText(RefactoringMessages.DELETE_DEEP_REMOVE);
            this.check.setSelection(true);
            this.updateRefactoring(true);
            this.check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRefactoringInputPage.this.updateRefactoring(DeleteRefactoringInputPage.this.check.getSelection());
                }
            });
            this.update = new Button(parent, 32);
            this.update.setText(RefactoringMessages.DeleteResourcesWizard_project_updateContents);
            this.update.setSelection(true);
            this.updateUpdateRefactoring(true);
            this.update.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRefactoringInputPage.this.updateUpdateRefactoring(DeleteRefactoringInputPage.this.update.getSelection());
                }
            });
        }

        private void addProjectCheckBox(Composite parent) {
            this.delete = new Button(parent, 32);
            this.update = new Button(parent, 32);
            this.update.setText(RefactoringMessages.DeleteResourcesWizard_project_updateContents);
            this.update.setSelection(false);
            if (this.refactoring.isProjectClosed()) {
                this.update.setEnabled(false);
            }
            this.updateUpdateRefactoring(false);
            this.update.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRefactoringInputPage.this.updateUpdateRefactoring(DeleteRefactoringInputPage.this.update.getSelection());
                }
            });
            this.check = new Button(parent, 32);
            if (this.refactoring.isProjectClosed()) {
                this.check.setEnabled(false);
            }
            this.check.setText(RefactoringMessages.DELETE_DEEP_REMOVE);
            this.check.setSelection(false);
            this.updateRefactoring(false);
            this.check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRefactoringInputPage.this.updateRefactoring(DeleteRefactoringInputPage.this.check.getSelection());
                }
            });
            this.delete.setText(RefactoringMessages.DeleteResourcesWizard_project_deleteContents);
            this.delete.setSelection(false);
            this.updateDelete(false);
            this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeleteRefactoringInputPage.this.updateDelete(DeleteRefactoringInputPage.this.delete.getSelection());
                }
            });
        }

        private void updateForcePreview() {
            DeleteRefactoringWizard.this.setForcePreviewReview(this.refactoring.getDeepRemove() || (this.refactoring.isProjectRemove() && this.refactoring.getPhysicalDelete()) | this.refactoring.getUpdate());
        }

        protected void updateRefactoring(boolean deepRemove) {
            this.refactoring.setDeepRemove(deepRemove);
            this.updateForcePreview();
        }

        protected void updateUpdateRefactoring(boolean updateValue) {
            this.refactoring.setUpdate(updateValue);
            this.updateForcePreview();
        }

        public boolean canFlipToNextPage() {
            return true;
        }

        protected void updateDelete(boolean realDelete) {
            this.refactoring.setPhysicalDelete(realDelete);
            this.updateForcePreview();
            if (realDelete) {
                if (!this.refactoring.isProjectClosed()) {
                    this.check.setSelection(realDelete);
                    this.update.setSelection(realDelete);
                    this.check.setEnabled(false);
                    this.update.setEnabled(false);
                    DeleteRefactoringWizard.this.page.getContainer().updateButtons();
                    this.updateUpdateRefactoring(this.update.getSelection());
                    this.updateRefactoring(this.check.getSelection());
                }
            } else if (!this.refactoring.isProjectClosed()) {
                this.check.setEnabled(true);
                this.update.setEnabled(true);
                DeleteRefactoringWizard.this.page.getContainer().updateButtons();
            }
        }

        private Control addLabel(Composite parent) {
            Label label = new Label(parent, 0);
            int containers = this.refactoring.getContainers().size();
            int proxies = this.refactoring.getProxies().size();
            String text = containers == 0 && proxies == 1 ? NLS.bind((String)RefactoringMessages.DELETE_CONFIRM_1, (Object)((IProxyNode)this.refactoring.getProxies().get(0)).getText()) : (containers == 1 && proxies == 0 ? NLS.bind((String)RefactoringMessages.DELETE_CONFIRM_1, (Object)((IResource)this.refactoring.getContainers().get(0)).getName()) : NLS.bind((String)RefactoringMessages.DELETE_CONFIRM_N, (Object)String.valueOf(containers + proxies)));
            label.setText(text);
            label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 4, false, true));
            return label;
        }
    }
}

