/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class ModelPathChange
extends Change {
    private EObjectProxyNode referenced;
    private EMFRefactoringTransaction context;
    private IPath newPath;

    public ModelPathChange(EObjectProxyNode node, IRefactoringContext context, IPath destinationPath) {
        this.referenced = node;
        this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
        this.newPath = destinationPath;
        Assert.isNotNull((Object)this.context);
    }

    public Object getModifiedElement() {
        return this.referenced;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.UPDATE_PROXY_PATH_CHANGED, (Object)this.referenced.getText());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Resource res = this.context.getResourceSet().getResource(this.referenced.getOriginatorURI().trimFragment(), true);
        this.context.addSavedResource(res);
        this.context.addChangedResourceURI(res, URI.createPlatformResourceURI((String)this.newPath.toPortableString(), (boolean)false));
        return null;
    }
}

