/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveFolderChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class MoveFolderCompositeChange
extends CompositeChange {
    private IFolder folder;
    private MoveFolderChange root;

    public MoveFolderCompositeChange(IFolder folder, IPath newPath) {
        super("");
        this.folder = folder;
        this.root = new MoveFolderChange(folder, newPath);
    }

    public Object getModifiedElement() {
        return this.folder;
    }

    public String getName() {
        return this.root.getName();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = this.root.isValid(pm);
        if (this.folder.getFullPath().isPrefixOf(this.root.getDestinationPath())) {
            status.addFatalError(RefactoringMessages.INNER_FOLDER_MOVE_ERROR);
        }
        status.merge(super.isValid(pm));
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        CompositeChange undo = new CompositeChange("undo MoveFolderCompositeChange");
        pm.beginTask("", this.getChildren().length + 1);
        try {
            undo.add(super.perform((IProgressMonitor)new SubProgressMonitor(pm, this.getChildren().length)));
            undo.add(this.root.perform((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        finally {
            pm.done();
        }
        return undo;
    }

    public void freeze() {
        if (this.getChildren().length == 0) {
            this.markAsSynthetic();
            this.add((Change)new NullChange(this.getName()));
        }
    }
}

