/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteFileChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.refactoring.AbstractPasteChange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class PasteFileChange
extends AbstractPasteChange {
    private IFile file = null;
    private IContainer destFolder;
    private String destName = null;
    private String externalBaseName = null;
    private String externalFileName = null;

    public PasteFileChange(IFile file, IContainer destination) {
        this.file = file;
        this.destFolder = destination;
        this.destName = PasteFileChange.buildNewName(this.destFolder.getFullPath().append(file.getName()));
    }

    public PasteFileChange(String externalFileName, IContainer destination) {
        this.file = null;
        this.destFolder = destination;
        this.externalFileName = externalFileName;
        this.externalBaseName = new Path(externalFileName).lastSegment();
        this.destName = PasteFileChange.buildNewName(this.destFolder.getFullPath().append(this.externalBaseName));
    }

    public Object getModifiedElement() {
        return this.file;
    }

    public String getName() {
        if (this.file != null) {
            IPath path = this.file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
            return NLS.bind((String)RefactoringMessages.PASTE_FILE, (Object)path.toString(), (Object)this.destName);
        }
        return NLS.bind((String)RefactoringMessages.PASTE_FILE, (Object)this.externalBaseName, (Object)this.destName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.file != null) {
            if (!this.file.exists()) {
                status.addError(RefactoringMessages.NO_FILE);
            }
        } else {
            File tmp = new File(this.externalFileName);
            if (!tmp.exists()) {
                status.addError(RefactoringMessages.NO_FILE);
            }
        }
        return status;
    }

    public String getNewName() {
        return this.destName;
    }

    public static String buildNewName(IPath destination) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.getFolder(destination).exists() || root.getFile(destination).exists()) {
            String newBaseName = null;
            boolean done = false;
            String fullFileName = destination.lastSegment();
            int dotIndex = fullFileName.lastIndexOf(46);
            String basePart = fullFileName.substring(0, dotIndex);
            String endPart = fullFileName.substring(dotIndex);
            String newFullName = null;
            String ret = null;
            int i = 0;
            while (!done) {
                newBaseName = i != 0 ? NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameTwoArg, (Object)new Integer(i), (Object)basePart) : NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameOneArg, (Object)basePart);
                newFullName = String.valueOf(newBaseName) + endPart;
                ret = destination.removeLastSegments(1).append(newFullName).toPortableString();
                Path newpath = new Path(ret);
                done = !root.getFolder((IPath)newpath).exists() && !root.getFile((IPath)newpath).exists();
                ++i;
            }
            return ret;
        }
        return destination.toPortableString();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        DeleteFileChange undo = null;
        pm.beginTask("", 1);
        try {
            if (this.file != null) {
                IContainer parent = this.file.getParent();
                this.file.copy((IPath)new Path(this.destName), false, pm);
                if (parent != null) {
                    IFile destFile = this.destFolder.getFile((IPath)new Path(new Path(this.destName).lastSegment()));
                    undo = new DeleteFileChange(destFile);
                }
                this.file.refreshLocal(0, pm);
            } else {
                IFile file = this.destFolder.getFile((IPath)new Path(new Path(this.destName).lastSegment()));
                try {
                    FileInputStream source = new FileInputStream(this.externalFileName);
                    if (file.exists()) {
                        file.setContents((InputStream)source, true, false, null);
                    } else {
                        file.create((InputStream)source, true, null);
                    }
                    ((InputStream)source).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    UiPlugin.logError(RefactoringMessages.NO_FILE);
                }
                catch (IOException e) {
                    UiPlugin.logError(RefactoringMessages.IO_ERROR_PASTING_FILE);
                    new ErrorDialog(Display.getDefault().getActiveShell(), RefactoringMessages.ERROR, NLS.bind((String)RefactoringMessages.IO_ERROR_PASTING_FILE, (Object)file.getName()), (IStatus)new Status(4, "org.eclipse.hyades.test.ui", 0, e.toString(), (Throwable)e), 4).open();
                }
                undo = new DeleteFileChange(this.destFolder.getFile((IPath)new Path(new Path(this.destName).lastSegment())));
            }
            pm.worked(1);
            DeleteFileChange deleteFileChange = undo;
            return deleteFileChange;
        }
        finally {
            pm.done();
        }
    }
}

