/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.ReorgContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class PasteFolderChange
extends ReorgContainerChange {
    private IPath destPath;
    private IPath targetPath;
    private RefactoringStatus status;
    private IFolder folder;

    public PasteFolderChange(IFolder folder, IPath destPath, IPath[] finalPath) {
        super((IContainer)folder);
        this.folder = folder;
        this.destPath = destPath;
        this.status = new RefactoringStatus();
        this.targetPath = this.handleFolderAlreadyExists(folder, destPath);
        if (finalPath != null && finalPath.length > 0) {
            finalPath[0] = this.targetPath;
        }
    }

    private IPath handleFolderAlreadyExists(IFolder folder, IPath destPath) {
        IPath path = destPath.append(folder.getName());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.getFolder(path).exists() || root.getFile(path).exists()) {
            boolean done = false;
            String folderName = path.lastSegment();
            String ret = null;
            String newName = null;
            int i = 0;
            while (!done) {
                newName = i != 0 ? NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameTwoArg, (Object)new Integer(i), (Object)folderName) : NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameOneArg, (Object)folderName);
                ret = path.removeLastSegments(1).append(newName).toPortableString();
                Path newpath = new Path(ret);
                done = !root.getFolder((IPath)newpath).exists() && !root.getFile((IPath)newpath).exists();
                ++i;
            }
            path = destPath.append(newName);
        }
        return path;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus localStatus = this.status;
        String targetDir = this.targetPath.toOSString();
        if (!TestUIUtil.isResourcePathLengthValid(targetDir)) {
            localStatus.addFatalError(RefactoringMessages.LONG_NAME);
        }
        IResource[] members = this.folder.members();
        int i = 0;
        while (i < members.length) {
            if (!TestUIUtil.isResourcePathLengthValid(String.valueOf(this.targetPath.toOSString()) + "\\" + members[i].getName())) {
                localStatus.addFatalError(RefactoringMessages.LONG_NAME);
            }
            ++i;
        }
        return localStatus;
    }

    public IPath getDestinationPath() {
        return this.destPath;
    }

    public String getName() {
        IPath path = this.getPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
        return NLS.bind((String)RefactoringMessages.PASTE_FOLDER, (Object)path.toString(), (Object)this.targetPath.toString());
    }

    public Change reorgFolder(IContainer container, SubProgressMonitor monitor) {
        DeleteContainerChange undo = null;
        try {
            container.copy(this.targetPath, 0, (IProgressMonitor)monitor);
            container.refreshLocal(2, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            UiPlugin.logError("Unable to copy container", e);
        }
        undo = new DeleteContainerChange((IContainer)ResourcesPlugin.getWorkspace().getRoot().getFolder(this.targetPath), true, null);
        TestUIUtilities.recursiveRefreshProxy((IResource)ResourcesPlugin.getWorkspace().getRoot().getFolder(this.targetPath));
        return undo;
    }
}

